% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_address}
\alias{ec2_associate_address}
\title{Associates an Elastic IP address with an instance or a network interface}
\usage{
ec2_associate_address(AllocationId, InstanceId, PublicIp,
  AllowReassociation, DryRun, NetworkInterfaceId, PrivateIpAddress)
}
\arguments{
\item{AllocationId}{[EC2-VPC] The allocation ID. This is required for EC2-VPC.}

\item{InstanceId}{The ID of the instance. This is required for EC2-Classic. For EC2-VPC,
you can specify either the instance ID or the network interface ID, but
not both. The operation fails if you specify an instance ID unless
exactly one network interface is attached.}

\item{PublicIp}{The Elastic IP address to associate with the instance. This is required
for EC2-Classic.}

\item{AllowReassociation}{[EC2-VPC] For a VPC in an EC2-Classic account, specify true to allow
an Elastic IP address that is already associated with an instance or
network interface to be reassociated with the specified instance or
network interface. Otherwise, the operation fails. In a VPC in an
EC2-VPC-only account, reassociation is automatic, therefore you can
specify false to ensure the operation fails if the Elastic IP address is
already associated with another resource.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NetworkInterfaceId}{[EC2-VPC] The ID of the network interface. If the instance has more
than one network interface, you must specify a network interface ID.

For EC2-VPC, you can specify either the instance ID or the network
interface ID, but not both.}

\item{PrivateIpAddress}{[EC2-VPC] The primary or secondary private IP address to associate
with the Elastic IP address. If no private IP address is specified, the
Elastic IP address is associated with the primary private IP address.}
}
\description{
Associates an Elastic IP address with an instance or a network
interface. Before you can use an Elastic IP address, you must allocate
it to your account.
}
\details{
An Elastic IP address is for use in either the EC2-Classic platform or
in a VPC. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

[EC2-Classic, VPC in an EC2-VPC-only account] If the Elastic IP
address is already associated with a different instance, it is
disassociated from that instance and associated with the specified
instance. If you associate an Elastic IP address with an instance that
has an existing Elastic IP address, the existing address is
disassociated from the instance, but remains allocated to your account.

[VPC in an EC2-Classic account] If you don\'t specify a private IP
address, the Elastic IP address is associated with the primary IP
address. If the Elastic IP address is already associated with a
different instance or a network interface, you get an error unless you
allow reassociation. You cannot associate an Elastic IP address with an
instance or network interface that has an existing Elastic IP address.

You cannot associate an Elastic IP address with an interface in a
different network border group.

This is an idempotent operation. If you perform the operation more than
once, Amazon EC2 doesn\'t return an error, and you may be charged for
each time the Elastic IP address is remapped to the same instance. For
more information, see the \emph{Elastic IP Addresses} section of \href{http://aws.amazon.com/ec2/pricing/}{Amazon EC2 Pricing}.
}
\section{Request syntax}{
\preformatted{svc$associate_address(
  AllocationId = "string",
  InstanceId = "string",
  PublicIp = "string",
  AllowReassociation = TRUE|FALSE,
  DryRun = TRUE|FALSE,
  NetworkInterfaceId = "string",
  PrivateIpAddress = "string"
)
}
}

\examples{
# This example associates the specified Elastic IP address with the
# specified instance in a VPC.
\donttest{svc$associate_address(
  AllocationId = "eipalloc-64d5890a",
  InstanceId = "i-0b263919b6498b123"
)}

# This example associates the specified Elastic IP address with the
# specified network interface.
\donttest{svc$associate_address(
  AllocationId = "eipalloc-64d5890a",
  NetworkInterfaceId = "eni-1a2b3c4d"
)}

# This example associates an Elastic IP address with an instance in
# EC2-Classic.
\donttest{svc$associate_address(
  InstanceId = "i-07ffe74c7330ebf53",
  PublicIp = "198.51.100.0"
)}

}
\keyword{internal}
