% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_function_concurrency}
\alias{lambda_put_function_concurrency}
\title{Sets the maximum number of simultaneous executions for a function, and
reserves capacity for that concurrency level}
\usage{
lambda_put_function_concurrency(FunctionName,
  ReservedConcurrentExecutions)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{ReservedConcurrentExecutions}{[required] The number of simultaneous executions to reserve for the function.}
}
\description{
Sets the maximum number of simultaneous executions for a function, and
reserves capacity for that concurrency level.
}
\details{
Concurrency settings apply to the function as a whole, including all
published versions and the unpublished version. Reserving concurrency
both ensures that your function has capacity to process the specified
number of events simultaneously, and prevents it from scaling beyond
that level. Use GetFunction to see the current setting for a function.

Use GetAccountSettings to see your Regional concurrency limit. You can
reserve concurrency for as many functions as you like, as long as you
leave at least 100 simultaneous executions unreserved for functions that
aren\'t configured with a per-function limit. For more information, see
\href{https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html}{Managing Concurrency}.
}
\section{Request syntax}{
\preformatted{svc$put_function_concurrency(
  FunctionName = "string",
  ReservedConcurrentExecutions = 123
)
}
}

\keyword{internal}
