% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_dhcp_options}
\alias{ec2_describe_dhcp_options}
\title{Describes one or more of your DHCP options sets}
\usage{
ec2_describe_dhcp_options(DhcpOptionsIds, Filters, DryRun, NextToken,
  MaxResults)
}
\arguments{
\item{DhcpOptionsIds}{The IDs of one or more DHCP options sets.

Default: Describes all your DHCP options sets.}

\item{Filters}{One or more filters.
\itemize{
\item \code{dhcp-options-id} - The ID of a DHCP options set.
\item \code{key} - The key for one of the options (for example, \code{domain-name}).
\item \code{value} - The value for one of the options.
\item \code{owner-id} - The ID of the AWS account that owns the DHCP options
set.
\item \code{tag}:\\<key\\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Describes one or more of your DHCP options sets.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html}{DHCP Options Sets}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_dhcp_options(
  DhcpOptionsIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE,
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# This example describes the specified DHCP options set.
\donttest{svc$describe_dhcp_options(
  DhcpOptionsIds = list(
    "dopt-d9070ebb"
  )
)}

}
\keyword{internal}
