% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_layer_versions}
\alias{lambda_list_layer_versions}
\title{Lists the versions of an AWS Lambda layer}
\usage{
lambda_list_layer_versions(CompatibleRuntime, LayerName, Marker,
  MaxItems)
}
\arguments{
\item{CompatibleRuntime}{A runtime identifier. For example, \code{go1.x}.}

\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{Marker}{A pagination token returned by a previous call.}

\item{MaxItems}{The maximum number of versions to return.}
}
\description{
Lists the versions of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer}.
Versions that have been deleted aren't listed. Specify a \href{https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html}{runtime identifier}
to list only versions that indicate that they're compatible with that
runtime.
}
\section{Request syntax}{
\preformatted{svc$list_layer_versions(
  CompatibleRuntime = "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"java8"|"python2.7"|"python3.6"|"python3.7"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"provided",
  LayerName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
