% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_detach_network_interface}
\alias{ec2_detach_network_interface}
\title{Detaches a network interface from an instance}
\usage{
ec2_detach_network_interface(AttachmentId, DryRun, Force)
}
\arguments{
\item{AttachmentId}{[required] The ID of the attachment.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Force}{Specifies whether to force a detachment.}
}
\description{
Detaches a network interface from an instance.
}
\section{Request syntax}{
\preformatted{svc$detach_network_interface(
  AttachmentId = "string",
  DryRun = TRUE|FALSE,
  Force = TRUE|FALSE
)
}
}

\examples{
# This example detaches the specified network interface from its attached
# instance.
\donttest{svc$detach_network_interface(
  AttachmentId = "eni-attach-66c4350a"
)}

}
\keyword{internal}
