% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_batch_check_layer_availability}
\alias{ecr_batch_check_layer_availability}
\title{Check the availability of multiple image layers in a specified registry
and repository}
\usage{
ecr_batch_check_layer_availability(registryId, repositoryName,
  layerDigests)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the image
layers to check. If you do not specify a registry, the default registry
is assumed.}

\item{repositoryName}{[required] The name of the repository that is associated with the image layers to
check.}

\item{layerDigests}{[required] The digests of the image layers to check.}
}
\description{
Check the availability of multiple image layers in a specified registry
and repository.
}
\details{
This operation is used by the Amazon ECR proxy, and it is not intended
for general use by customers for pulling and pushing images. In most
cases, you should use the \code{docker} CLI to pull, tag, and push images.
}
\section{Request syntax}{
\preformatted{svc$batch_check_layer_availability(
  registryId = "string",
  repositoryName = "string",
  layerDigests = list(
    "string"
  )
)
}
}

\keyword{internal}
