% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_tag_resource}
\alias{lightsail_tag_resource}
\title{Adds one or more tags to the specified Amazon Lightsail resource}
\usage{
lightsail_tag_resource(resourceName, tags)
}
\arguments{
\item{resourceName}{[required] The name of the resource to which you are adding tags.}

\item{tags}{[required] The tag key and optional value.}
}
\description{
Adds one or more tags to the specified Amazon Lightsail resource. Each
resource can have a maximum of 50 tags. Each tag consists of a key and
an optional value. Tag keys must be unique per resource. For more
information about tags, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags}{Lightsail Dev Guide}.
}
\details{
The \code{tag resource} operation supports tag-based access control via
request tags and resource tags applied to the resource identified by
resourceName. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  resourceName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
