% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_launch_template_versions}
\alias{ec2_describe_launch_template_versions}
\title{Describes one or more versions of a specified launch template}
\usage{
ec2_describe_launch_template_versions(DryRun, LaunchTemplateId,
  LaunchTemplateName, Versions, MinVersion, MaxVersion, NextToken,
  MaxResults, Filters)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LaunchTemplateId}{The ID of the launch template. You must specify either the launch
template ID or launch template name in the request.}

\item{LaunchTemplateName}{The name of the launch template. You must specify either the launch
template ID or launch template name in the request.}

\item{Versions}{One or more versions of the launch template.}

\item{MinVersion}{The version number after which to describe launch template versions.}

\item{MaxVersion}{The version number up to which to describe launch template versions.}

\item{NextToken}{The token to request the next page of results.}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned \code{NextToken}
value. This value can be between 1 and 200.}

\item{Filters}{One or more filters.
\itemize{
\item \code{create-time} - The time the launch template version was created.
\item \code{ebs-optimized} - A boolean that indicates whether the instance is
optimized for Amazon EBS I/O.
\item \code{iam-instance-profile} - The ARN of the IAM instance profile.
\item \code{image-id} - The ID of the AMI.
\item \code{instance-type} - The instance type.
\item \code{is-default-version} - A boolean that indicates whether the launch
template version is the default version.
\item \code{kernel-id} - The kernel ID.
\item \code{ram-disk-id} - The RAM disk ID.
}}
}
\description{
Describes one or more versions of a specified launch template. You can
describe all versions, individual versions, or a range of versions.
}
\section{Request syntax}{
\preformatted{svc$describe_launch_template_versions(
  DryRun = TRUE|FALSE,
  LaunchTemplateId = "string",
  LaunchTemplateName = "string",
  Versions = list(
    "string"
  ),
  MinVersion = "string",
  MaxVersion = "string",
  NextToken = "string",
  MaxResults = 123,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\examples{
# This example describes the versions for the specified launch template.
\donttest{svc$describe_launch_template_versions(
  LaunchTemplateId = "068f72b72934aff71"
)}

}
\keyword{internal}
