% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_domain_entry}
\alias{lightsail_create_domain_entry}
\title{Creates one of the following domain name system (DNS) records in a
domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
(MX), name server (NS), start of authority (SOA), service locator (SRV),
or text (TXT)}
\usage{
lightsail_create_domain_entry(domainName, domainEntry)
}
\arguments{
\item{domainName}{[required] The domain name (e.g., \code{example.com}) for which you want to create the
domain entry.}

\item{domainEntry}{[required] An array of key-value pairs containing information about the domain
entry request.}
}
\value{
A list with the following syntax:\preformatted{list(
  operation = list(
    id = "string",
    resourceName = "string",
    resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    location = list(
      availabilityZone = "string",
      regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
    ),
    isTerminal = TRUE|FALSE,
    operationDetails = "string",
    operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
    status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
    statusChangedAt = as.POSIXct(
      "2015-01-01"
    ),
    errorCode = "string",
    errorDetails = "string"
  )
)
}
}
\description{
Creates one of the following domain name system (DNS) records in a
domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
(MX), name server (NS), start of authority (SOA), service locator (SRV),
or text (TXT).

The \verb{create domain entry} operation supports tag-based access control
via resource tags applied to the resource identified by \verb{domain name}.
For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_domain_entry(
  domainName = "string",
  domainEntry = list(
    id = "string",
    name = "string",
    target = "string",
    isAlias = TRUE|FALSE,
    type = "string",
    options = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
