% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_local_gateway_virtual_interface_groups}
\alias{ec2_describe_local_gateway_virtual_interface_groups}
\title{Describes the specified local gateway virtual interface groups}
\usage{
ec2_describe_local_gateway_virtual_interface_groups(
  LocalGatewayVirtualInterfaceGroupIds, Filters, MaxResults, NextToken,
  DryRun)
}
\arguments{
\item{LocalGatewayVirtualInterfaceGroupIds}{The IDs of the virtual interface groups.}

\item{Filters}{One or more filters.
\itemize{
\item \code{local-gateway-id} - The ID of a local gateway.
\item \code{local-gateway-virtual-interface-id} - The ID of the virtual
interface.
\item \code{local-gateway-virtual-interface-group-id} - The ID of the virtual
interface group.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  LocalGatewayVirtualInterfaceGroups = list(
    list(
      LocalGatewayVirtualInterfaceGroupId = "string",
      LocalGatewayVirtualInterfaceIds = list(
        "string"
      ),
      LocalGatewayId = "string",
      OwnerId = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the specified local gateway virtual interface groups.
}
\section{Request syntax}{
\preformatted{svc$describe_local_gateway_virtual_interface_groups(
  LocalGatewayVirtualInterfaceGroupIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
