% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_configuration_options}
\alias{elasticbeanstalk_describe_configuration_options}
\title{Describes the configuration options that are used in a particular
configuration template or environment, or that a specified solution
stack defines}
\usage{
elasticbeanstalk_describe_configuration_options(ApplicationName,
  TemplateName, EnvironmentName, SolutionStackName, PlatformArn, Options)
}
\arguments{
\item{ApplicationName}{The name of the application associated with the configuration template
or environment. Only needed if you want to describe the configuration
options associated with either the configuration template or
environment.}

\item{TemplateName}{The name of the configuration template whose configuration options you
want to describe.}

\item{EnvironmentName}{The name of the environment whose configuration options you want to
describe.}

\item{SolutionStackName}{The name of the solution stack whose configuration options you want to
describe.}

\item{PlatformArn}{The ARN of the custom platform.}

\item{Options}{If specified, restricts the descriptions to only the specified options.}
}
\value{
A list with the following syntax:\preformatted{list(
  SolutionStackName = "string",
  PlatformArn = "string",
  Options = list(
    list(
      Namespace = "string",
      Name = "string",
      DefaultValue = "string",
      ChangeSeverity = "string",
      UserDefined = TRUE|FALSE,
      ValueType = "Scalar"|"List",
      ValueOptions = list(
        "string"
      ),
      MinValue = 123,
      MaxValue = 123,
      MaxLength = 123,
      Regex = list(
        Pattern = "string",
        Label = "string"
      )
    )
  )
)
}
}
\description{
Describes the configuration options that are used in a particular
configuration template or environment, or that a specified solution
stack defines. The description includes the values the options, their
default values, and an indication of the required action on a running
environment if an option value is changed.
}
\section{Request syntax}{
\preformatted{svc$describe_configuration_options(
  ApplicationName = "string",
  TemplateName = "string",
  EnvironmentName = "string",
  SolutionStackName = "string",
  PlatformArn = "string",
  Options = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following operation retrieves descriptions of all available
# configuration options for an environment named my-env:
svc$describe_configuration_options(
  ApplicationName = "my-app",
  EnvironmentName = "my-env"
)
}

}
\keyword{internal}
