% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_export_client_vpn_client_configuration}
\alias{ec2_export_client_vpn_client_configuration}
\title{Downloads the contents of the Client VPN endpoint configuration file for
the specified Client VPN endpoint}
\usage{
ec2_export_client_vpn_client_configuration(ClientVpnEndpointId, DryRun)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ClientConfiguration = "string"
)
}
}
\description{
Downloads the contents of the Client VPN endpoint configuration file for
the specified Client VPN endpoint. The Client VPN endpoint configuration
file includes the Client VPN endpoint and certificate information
clients need to establish a connection with the Client VPN endpoint.
}
\section{Request syntax}{
\preformatted{svc$export_client_vpn_client_configuration(
  ClientVpnEndpointId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
