% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_connections}
\alias{ec2_describe_vpc_endpoint_connections}
\title{Describes the VPC endpoint connections to your VPC endpoint services,
including any endpoints that are pending your acceptance}
\usage{
ec2_describe_vpc_endpoint_connections(DryRun, Filters, MaxResults,
  NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters.
\itemize{
\item \code{service-id} - The ID of the service.
\item \code{vpc-endpoint-owner} - The AWS account number of the owner of the
endpoint.
\item \code{vpc-endpoint-state} - The state of the endpoint
(\code{pendingAcceptance} | \code{pending} | \code{available} | \code{deleting} |
\code{deleted} | \code{rejected} | \code{failed}).
\item \code{vpc-endpoint-id} - The ID of the endpoint.
}}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results of the initial request can be seen by
sending another request with the returned \code{NextToken} value. This value
can be between 5 and 1,000; if \code{MaxResults} is given a value larger than
1,000, only 1,000 results are returned.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  VpcEndpointConnections = list(
    list(
      ServiceId = "string",
      VpcEndpointId = "string",
      VpcEndpointOwner = "string",
      VpcEndpointState = "PendingAcceptance"|"Pending"|"Available"|"Deleting"|"Deleted"|"Rejected"|"Failed"|"Expired",
      CreationTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      DnsEntries = list(
        list(
          DnsName = "string",
          HostedZoneId = "string"
        )
      ),
      NetworkLoadBalancerArns = list(
        "string"
      ),
      GatewayLoadBalancerArns = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the VPC endpoint connections to your VPC endpoint services,
including any endpoints that are pending your acceptance.
}
\section{Request syntax}{
\preformatted{svc$describe_vpc_endpoint_connections(
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
