% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_traffic_mirror_filter}
\alias{ec2_create_traffic_mirror_filter}
\title{Creates a Traffic Mirror filter}
\usage{
ec2_create_traffic_mirror_filter(Description, TagSpecifications, DryRun,
  ClientToken)
}
\arguments{
\item{Description}{The description of the Traffic Mirror filter.}

\item{TagSpecifications}{The tags to assign to a Traffic Mirror filter.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}
}
\description{
Creates a Traffic Mirror filter.

A Traffic Mirror filter is a set of rules that defines the traffic to
mirror.

By default, no traffic is mirrored. To mirror traffic, use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/}{CreateTrafficMirrorFilterRule}
to add Traffic Mirror rules to the filter. The rules you add define what
traffic gets mirrored. You can also use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html}{ModifyTrafficMirrorFilterNetworkServices}
to mirror supported network services.
}
\section{Request syntax}{
\preformatted{svc$create_traffic_mirror_filter(
  Description = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE,
  ClientToken = "string"
)
}
}

\keyword{internal}
