% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_delete_compute_environment}
\alias{batch_delete_compute_environment}
\title{Deletes an AWS Batch compute environment}
\usage{
batch_delete_compute_environment(computeEnvironment)
}
\arguments{
\item{computeEnvironment}{[required] The name or Amazon Resource Name (ARN) of the compute environment to
delete.}
}
\description{
Deletes an AWS Batch compute environment.

Before you can delete a compute environment, you must set its state to
\code{DISABLED} with the UpdateComputeEnvironment API operation and
disassociate it from any job queues with the UpdateJobQueue API
operation. Compute environments that use AWS Fargate resources must
terminate all active jobs on that compute environment before deleting
the compute environment. If this isn't done, the compute environment
will end up in an invalid state.
}
\section{Request syntax}{
\preformatted{svc$delete_compute_environment(
  computeEnvironment = "string"
)
}
}

\examples{
\dontrun{
# This example deletes the P2OnDemand compute environment.
svc$delete_compute_environment(
  computeEnvironment = "P2OnDemand"
)
}

}
\keyword{internal}
