% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_register_container_image}
\alias{lightsail_register_container_image}
\title{Registers a container image to your Amazon Lightsail container service}
\usage{
lightsail_register_container_image(serviceName, label, digest)
}
\arguments{
\item{serviceName}{[required] The name of the container service for which to register a container
image.}

\item{label}{[required] The label for the container image when it's registered to the container
service.

Use a descriptive label that you can use to track the different versions
of your registered container images.

Use the \code{GetContainerImages} action to return the container images
registered to a Lightsail container service. The label is the
\verb{&lt;imagelabel&gt;} portion of the following image name example:
\itemize{
\item \verb{:container-service-1.&lt;imagelabel&gt;.1}
}

If the name of your container service is \code{mycontainerservice}, and the
label that you specify is \code{mystaticwebsite}, then the name of the
registered container image will be
\verb{:mycontainerservice.mystaticwebsite.1}.

The number at the end of these image name examples represents the
version of the registered container image. If you push and register
another container image to the same Lightsail container service, with
the same label, then the version number for the new registered container
image will be \code{2}. If you push and register another container image, the
version number will be \code{3}, and so on.}

\item{digest}{[required] The digest of the container image to be registered.}
}
\description{
Registers a container image to your Amazon Lightsail container service.

This action is not required if you install and use the Lightsail Control
(lightsailctl) plugin to push container images to your Lightsail
container service. For more information, see Pushing and managing
container images on your Amazon Lightsail container services in the
\emph{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$register_container_image(
  serviceName = "string",
  label = "string",
  digest = "string"
)
}
}

\keyword{internal}
