% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_close_instance_public_ports}
\alias{lightsail_close_instance_public_ports}
\title{Closes ports for a specific Amazon Lightsail instance}
\usage{
lightsail_close_instance_public_ports(portInfo, instanceName)
}
\arguments{
\item{portInfo}{[required] An object to describe the ports to close for the specified instance.}

\item{instanceName}{[required] The name of the instance for which to close ports.}
}
\description{
Closes ports for a specific Amazon Lightsail instance.

The \code{CloseInstancePublicPorts} action supports tag-based access control
via resource tags applied to the resource identified by \code{instanceName}.
For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$close_instance_public_ports(
  portInfo = list(
    fromPort = 123,
    toPort = 123,
    protocol = "tcp"|"all"|"udp"|"icmp",
    cidrs = list(
      "string"
    ),
    cidrListAliases = list(
      "string"
    )
  ),
  instanceName = "string"
)
}
}

\keyword{internal}
