% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_delete_layer_version}
\alias{lambda_delete_layer_version}
\title{Deletes a version of an AWS Lambda layer}
\usage{
lambda_delete_layer_version(LayerName, VersionNumber)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{VersionNumber}{[required] The version number.}
}
\description{
Deletes a version of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer}.
Deleted versions can no longer be viewed or added to functions. To avoid
breaking functions, a copy of the version remains in Lambda until no
functions refer to it.
}
\section{Request syntax}{
\preformatted{svc$delete_layer_version(
  LayerName = "string",
  VersionNumber = 123
)
}
}

\examples{
\dontrun{
# The following example deletes version 2 of a layer named my-layer.
svc$delete_layer_version(
  LayerName = "my-layer",
  VersionNumber = 2L
)
}

}
\keyword{internal}
