% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_network_insights_paths}
\alias{ec2_describe_network_insights_paths}
\title{Describes one or more of your paths}
\usage{
ec2_describe_network_insights_paths(NetworkInsightsPathIds, Filters,
  MaxResults, DryRun, NextToken)
}
\arguments{
\item{NetworkInsightsPathIds}{The IDs of the paths.}

\item{Filters}{The filters. The following are possible values:
\itemize{
\item Destination - The ID of the resource.
\item DestinationPort - The destination port.
\item Name - The path name.
\item Protocol - The protocol.
\item Source - The ID of the resource.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more of your paths.
}
\section{Request syntax}{
\preformatted{svc$describe_network_insights_paths(
  NetworkInsightsPathIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  DryRun = TRUE|FALSE,
  NextToken = "string"
)
}
}

\keyword{internal}
