% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_local_gateway_route}
\alias{ec2_create_local_gateway_route}
\title{Creates a static route for the specified local gateway route table}
\usage{
ec2_create_local_gateway_route(DestinationCidrBlock,
  LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId, DryRun)
}
\arguments{
\item{DestinationCidrBlock}{[required] The CIDR range used for destination matches. Routing decisions are based
on the most specific match.}

\item{LocalGatewayRouteTableId}{[required] The ID of the local gateway route table.}

\item{LocalGatewayVirtualInterfaceGroupId}{[required] The ID of the virtual interface group.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a static route for the specified local gateway route table.
}
\section{Request syntax}{
\preformatted{svc$create_local_gateway_route(
  DestinationCidrBlock = "string",
  LocalGatewayRouteTableId = "string",
  LocalGatewayVirtualInterfaceGroupId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
