% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_service_configurations}
\alias{ec2_describe_vpc_endpoint_service_configurations}
\title{Describes the VPC endpoint service configurations in your account (your
services)}
\usage{
ec2_describe_vpc_endpoint_service_configurations(DryRun, ServiceIds,
  Filters, MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceIds}{The IDs of one or more services.}

\item{Filters}{One or more filters.
\itemize{
\item \code{service-name} - The name of the service.
\item \code{service-id} - The ID of the service.
\item \code{service-state} - The state of the service (\code{Pending} \| \code{Available}
\| \code{Deleting} \| \code{Deleted} \| \code{Failed}).
}}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results of the initial request can be seen by
sending another request with the returned \code{NextToken} value. This value
can be between 5 and 1000; if \code{MaxResults} is given a value larger than
1000, only 1000 results are returned.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\description{
Describes the VPC endpoint service configurations in your account (your
services).
}
\section{Request syntax}{
\preformatted{svc$describe_vpc_endpoint_service_configurations(
  DryRun = TRUE|FALSE,
  ServiceIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
