% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_copy_image}
\alias{ec2_copy_image}
\title{Initiates the copy of an AMI from the specified source region to the
current region}
\usage{
ec2_copy_image(ClientToken, Description, Encrypted, KmsKeyId, Name,
  SourceImageId, SourceRegion, DryRun)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html}{How to Ensure Idempotency}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Description}{A description for the new AMI in the destination region.}

\item{Encrypted}{Specifies whether the destination snapshots of the copied image should
be encrypted. You can encrypt a copy of an unencrypted snapshot, but you
cannot create an unencrypted copy of an encrypted snapshot. The default
CMK for EBS is used unless you specify a non-default AWS Key Management
Service (AWS KMS) CMK using \code{KmsKeyId}. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{KmsKeyId}{An identifier for the AWS Key Management Service (AWS KMS) customer
master key (CMK) to use when creating the encrypted volume. This
parameter is only required if you want to use a non-default CMK; if this
parameter is not specified, the default CMK for EBS is used. If a
\code{KmsKeyId} is specified, the \code{Encrypted} flag must also be set.

The CMK identifier may be provided in any of the following formats:
\itemize{
\item Key ID
\item Key alias, in the form \code{alias/<i>ExampleAlias</i> }
\item ARN using key ID. The ID ARN contains the \code{arn:aws:kms} namespace,
followed by the region of the CMK, the AWS account ID of the CMK
owner, the \code{key} namespace, and then the CMK ID. For example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:key/\emph{abcd1234-a123-456a-a12b-a123b4cd56ef}.
\item ARN using key alias. The alias ARN contains the \code{arn:aws:kms}
namespace, followed by the region of the CMK, the AWS account ID of
the CMK owner, the \code{alias} namespace, and then the CMK alias. For
example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:alias/\emph{ExampleAlias}.
}

AWS parses \code{KmsKeyId} asynchronously, meaning that the action you call
may appear to complete even though you provided an invalid identifier.
This action will eventually report failure.

The specified CMK must exist in the region that the snapshot is being
copied to.}

\item{Name}{[required] The name of the new AMI in the destination region.}

\item{SourceImageId}{[required] The ID of the AMI to copy.}

\item{SourceRegion}{[required] The name of the region that contains the AMI to copy.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Initiates the copy of an AMI from the specified source region to the
current region. You specify the destination region by using its endpoint
when making the request.
}
\details{
Copies of encrypted backing snapshots for the AMI are encrypted. Copies
of unencrypted backing snapshots remain unencrypted, unless you set
\code{Encrypted} during the copy operation. You cannot create an unencrypted
copy of an encrypted backing snapshot.

For more information about the prerequisites and limits when copying an
AMI, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html}{Copying an AMI}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$copy_image(
  ClientToken = "string",
  Description = "string",
  Encrypted = TRUE|FALSE,
  KmsKeyId = "string",
  Name = "string",
  SourceImageId = "string",
  SourceRegion = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example copies the specified AMI from the us-east-1 region to the
# current region.
\donttest{svc$copy_image(
  Description = "",
  Name = "My server",
  SourceImageId = "ami-5731123e",
  SourceRegion = "us-east-1"
)}

}
\keyword{internal}
