% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwaa_operations.R
\name{mwaa_invoke_rest_api}
\alias{mwaa_invoke_rest_api}
\title{Invokes the Apache Airflow REST API on the webserver with the specified
inputs}
\usage{
mwaa_invoke_rest_api(Name, Path, Method, QueryParameters = NULL, Body = NULL)
}
\arguments{
\item{Name}{[required] The name of the Amazon MWAA environment. For example,
\code{MyMWAAEnvironment}.}

\item{Path}{[required] The Apache Airflow REST API endpoint path to be called. For example,
\verb{/dags/123456/clearTaskInstances}. For more information, see \href{https://airflow.apache.org/docs/apache-airflow/stable/stable-rest-api-ref.html}{Apache Airflow API}}

\item{Method}{[required] The HTTP method used for making Airflow REST API calls. For example,
\code{POST}.}

\item{QueryParameters}{Query parameters to be included in the Apache Airflow REST API call,
provided as a JSON object.}

\item{Body}{The request body for the Apache Airflow REST API call, provided as a
JSON object.}
}
\description{
Invokes the Apache Airflow REST API on the webserver with the specified inputs. To learn more, see \href{https://docs.aws.amazon.com/mwaa/latest/userguide/access-mwaa-apache-airflow-rest-api.html}{Using the Apache Airflow REST API}

See \url{https://www.paws-r-sdk.com/docs/mwaa_invoke_rest_api/} for full documentation.
}
\keyword{internal}
