% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_create_connection}
\alias{eventbridge_create_connection}
\title{Creates a connection}
\usage{
eventbridge_create_connection(
  Name,
  Description = NULL,
  AuthorizationType,
  AuthParameters,
  InvocationConnectivityParameters = NULL
)
}
\arguments{
\item{Name}{[required] The name for the connection to create.}

\item{Description}{A description for the connection to create.}

\item{AuthorizationType}{[required] The type of authorization to use for the connection.

OAUTH tokens are refreshed when a 401 or 407 response is returned.}

\item{AuthParameters}{[required] The authorization parameters to use to authorize with the endpoint.

You must include only authorization parameters for the
\code{AuthorizationType} you specify.}

\item{InvocationConnectivityParameters}{For connections to private resource endpoints, the parameters to use for
invoking the resource endpoint.

For more information, see \href{https://docs.aws.amazon.com/eventbridge/latest/userguide/}{Connecting to private resources} in
the \emph{Amazon EventBridge User Guide} .}
}
\description{
Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.

See \url{https://www.paws-r-sdk.com/docs/eventbridge_create_connection/} for full documentation.
}
\keyword{internal}
