# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eventbridgescheduler_service.R
NULL

#' Creates the specified schedule
#'
#' @description
#' Creates the specified schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_create_schedule/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_create_schedule/) for full documentation.
#'
#' @param ActionAfterCompletion Specifies the action that EventBridge Scheduler applies to the schedule
#' after the schedule completes invoking the target.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you do not specify a client token, EventBridge
#' Scheduler uses a randomly generated token for the request to ensure
#' idempotency.
#' @param Description The description you specify for the schedule.
#' @param EndDate The date, in UTC, before which the schedule can invoke its target.
#' Depending on the schedule's recurrence expression, invocations might
#' stop on, or before, the `EndDate` you specify. EventBridge Scheduler
#' ignores `EndDate` for one-time schedules.
#' @param FlexibleTimeWindow &#91;required&#93; Allows you to configure a time window during which EventBridge Scheduler
#' invokes the schedule.
#' @param GroupName The name of the schedule group to associate with this schedule. If you
#' omit this, the default schedule group is used.
#' @param KmsKeyArn The Amazon Resource Name (ARN) for the customer managed KMS key that
#' EventBridge Scheduler will use to encrypt and decrypt your data.
#' @param Name &#91;required&#93; The name of the schedule that you are creating.
#' @param ScheduleExpression &#91;required&#93; The expression that defines when the schedule runs. The following
#' formats are supported.
#' 
#' -   `at` expression - `at(yyyy-mm-ddThh:mm:ss)`
#' 
#' -   `rate` expression - `rate(value unit)`
#' 
#' -   `cron` expression - `cron(fields)`
#' 
#' You can use `at` expressions to create one-time schedules that invoke a
#' target once, at the time and in the time zone, that you specify. You can
#' use `rate` and `cron` expressions to create recurring schedules.
#' Rate-based schedules are useful when you want to invoke a target at
#' regular intervals, such as every 15 minutes or every five days.
#' Cron-based schedules are useful when you want to invoke a target
#' periodically at a specific time, such as at 8:00 am (UTC+0) every 1st
#' day of the month.
#' 
#' A `cron` expression consists of six fields separated by white spaces:
#' `(minutes hours day_of_month month day_of_week year)`.
#' 
#' A `rate` expression consists of a *value* as a positive integer, and a
#' *unit* with the following options: `minute` | `minutes` | `hour` |
#' `hours` | `day` | `days`
#' 
#' For more information and examples, see [Schedule types on EventBridge
#' Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html)
#' in the *EventBridge Scheduler User Guide*.
#' @param ScheduleExpressionTimezone The timezone in which the scheduling expression is evaluated.
#' @param StartDate The date, in UTC, after which the schedule can begin invoking its
#' target. Depending on the schedule's recurrence expression, invocations
#' might occur on, or after, the `StartDate` you specify. EventBridge
#' Scheduler ignores `StartDate` for one-time schedules.
#' @param State Specifies whether the schedule is enabled or disabled.
#' @param Target &#91;required&#93; The schedule's target.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_create_schedule
eventbridgescheduler_create_schedule <- function(ActionAfterCompletion = NULL, ClientToken = NULL, Description = NULL, EndDate = NULL, FlexibleTimeWindow, GroupName = NULL, KmsKeyArn = NULL, Name, ScheduleExpression, ScheduleExpressionTimezone = NULL, StartDate = NULL, State = NULL, Target) {
  op <- new_operation(
    name = "CreateSchedule",
    http_method = "POST",
    http_path = "/schedules/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$create_schedule_input(ActionAfterCompletion = ActionAfterCompletion, ClientToken = ClientToken, Description = Description, EndDate = EndDate, FlexibleTimeWindow = FlexibleTimeWindow, GroupName = GroupName, KmsKeyArn = KmsKeyArn, Name = Name, ScheduleExpression = ScheduleExpression, ScheduleExpressionTimezone = ScheduleExpressionTimezone, StartDate = StartDate, State = State, Target = Target)
  output <- .eventbridgescheduler$create_schedule_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$create_schedule <- eventbridgescheduler_create_schedule

#' Creates the specified schedule group
#'
#' @description
#' Creates the specified schedule group.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_create_schedule_group/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_create_schedule_group/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you do not specify a client token, EventBridge
#' Scheduler uses a randomly generated token for the request to ensure
#' idempotency.
#' @param Name &#91;required&#93; The name of the schedule group that you are creating.
#' @param Tags The list of tags to associate with the schedule group.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_create_schedule_group
eventbridgescheduler_create_schedule_group <- function(ClientToken = NULL, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateScheduleGroup",
    http_method = "POST",
    http_path = "/schedule-groups/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$create_schedule_group_input(ClientToken = ClientToken, Name = Name, Tags = Tags)
  output <- .eventbridgescheduler$create_schedule_group_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$create_schedule_group <- eventbridgescheduler_create_schedule_group

#' Deletes the specified schedule
#'
#' @description
#' Deletes the specified schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_delete_schedule/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_delete_schedule/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you do not specify a client token, EventBridge
#' Scheduler uses a randomly generated token for the request to ensure
#' idempotency.
#' @param GroupName The name of the schedule group associated with this schedule. If you
#' omit this, the default schedule group is used.
#' @param Name &#91;required&#93; The name of the schedule to delete.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_delete_schedule
eventbridgescheduler_delete_schedule <- function(ClientToken = NULL, GroupName = NULL, Name) {
  op <- new_operation(
    name = "DeleteSchedule",
    http_method = "DELETE",
    http_path = "/schedules/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$delete_schedule_input(ClientToken = ClientToken, GroupName = GroupName, Name = Name)
  output <- .eventbridgescheduler$delete_schedule_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$delete_schedule <- eventbridgescheduler_delete_schedule

#' Deletes the specified schedule group
#'
#' @description
#' Deletes the specified schedule group. Deleting a schedule group results in EventBridge Scheduler deleting all schedules associated with the group. When you delete a group, it remains in a `DELETING` state until all of its associated schedules are deleted. Schedules associated with the group that are set to run while the schedule group is in the process of being deleted might continue to invoke their targets until the schedule group and its associated schedules are deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_delete_schedule_group/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_delete_schedule_group/) for full documentation.
#'
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you do not specify a client token, EventBridge
#' Scheduler uses a randomly generated token for the request to ensure
#' idempotency.
#' @param Name &#91;required&#93; The name of the schedule group to delete.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_delete_schedule_group
eventbridgescheduler_delete_schedule_group <- function(ClientToken = NULL, Name) {
  op <- new_operation(
    name = "DeleteScheduleGroup",
    http_method = "DELETE",
    http_path = "/schedule-groups/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$delete_schedule_group_input(ClientToken = ClientToken, Name = Name)
  output <- .eventbridgescheduler$delete_schedule_group_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$delete_schedule_group <- eventbridgescheduler_delete_schedule_group

#' Retrieves the specified schedule
#'
#' @description
#' Retrieves the specified schedule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_get_schedule/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_get_schedule/) for full documentation.
#'
#' @param GroupName The name of the schedule group associated with this schedule. If you
#' omit this, EventBridge Scheduler assumes that the schedule is associated
#' with the default group.
#' @param Name &#91;required&#93; The name of the schedule to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_get_schedule
eventbridgescheduler_get_schedule <- function(GroupName = NULL, Name) {
  op <- new_operation(
    name = "GetSchedule",
    http_method = "GET",
    http_path = "/schedules/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$get_schedule_input(GroupName = GroupName, Name = Name)
  output <- .eventbridgescheduler$get_schedule_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$get_schedule <- eventbridgescheduler_get_schedule

#' Retrieves the specified schedule group
#'
#' @description
#' Retrieves the specified schedule group.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_get_schedule_group/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_get_schedule_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the schedule group to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_get_schedule_group
eventbridgescheduler_get_schedule_group <- function(Name) {
  op <- new_operation(
    name = "GetScheduleGroup",
    http_method = "GET",
    http_path = "/schedule-groups/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$get_schedule_group_input(Name = Name)
  output <- .eventbridgescheduler$get_schedule_group_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$get_schedule_group <- eventbridgescheduler_get_schedule_group

#' Returns a paginated list of your schedule groups
#'
#' @description
#' Returns a paginated list of your schedule groups.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_list_schedule_groups/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_list_schedule_groups/) for full documentation.
#'
#' @param MaxResults If specified, limits the number of results returned by this operation.
#' The operation also returns a `NextToken` which you can use in a
#' subsequent operation to retrieve the next set of results.
#' @param NamePrefix The name prefix that you can use to return a filtered list of your
#' schedule groups.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_list_schedule_groups
eventbridgescheduler_list_schedule_groups <- function(MaxResults = NULL, NamePrefix = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListScheduleGroups",
    http_method = "GET",
    http_path = "/schedule-groups",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ScheduleGroups")
  )
  input <- .eventbridgescheduler$list_schedule_groups_input(MaxResults = MaxResults, NamePrefix = NamePrefix, NextToken = NextToken)
  output <- .eventbridgescheduler$list_schedule_groups_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$list_schedule_groups <- eventbridgescheduler_list_schedule_groups

#' Returns a paginated list of your EventBridge Scheduler schedules
#'
#' @description
#' Returns a paginated list of your EventBridge Scheduler schedules.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_list_schedules/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_list_schedules/) for full documentation.
#'
#' @param GroupName If specified, only lists the schedules whose associated schedule group
#' matches the given filter.
#' @param MaxResults If specified, limits the number of results returned by this operation.
#' The operation also returns a `NextToken` which you can use in a
#' subsequent operation to retrieve the next set of results.
#' @param NamePrefix Schedule name prefix to return the filtered list of resources.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param State If specified, only lists the schedules whose current state matches the
#' given filter.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_list_schedules
eventbridgescheduler_list_schedules <- function(GroupName = NULL, MaxResults = NULL, NamePrefix = NULL, NextToken = NULL, State = NULL) {
  op <- new_operation(
    name = "ListSchedules",
    http_method = "GET",
    http_path = "/schedules",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Schedules")
  )
  input <- .eventbridgescheduler$list_schedules_input(GroupName = GroupName, MaxResults = MaxResults, NamePrefix = NamePrefix, NextToken = NextToken, State = State)
  output <- .eventbridgescheduler$list_schedules_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$list_schedules <- eventbridgescheduler_list_schedules

#' Lists the tags associated with the Scheduler resource
#'
#' @description
#' Lists the tags associated with the Scheduler resource.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the EventBridge Scheduler resource for which you want to view
#' tags.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_list_tags_for_resource
eventbridgescheduler_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .eventbridgescheduler$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$list_tags_for_resource <- eventbridgescheduler_list_tags_for_resource

#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' Scheduler resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified EventBridge Scheduler resource. You can only assign tags to schedule groups.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_tag_resource/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the schedule group that you are adding
#' tags to.
#' @param Tags &#91;required&#93; The list of tags to associate with the schedule group.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_tag_resource
eventbridgescheduler_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .eventbridgescheduler$tag_resource_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$tag_resource <- eventbridgescheduler_tag_resource

#' Removes one or more tags from the specified EventBridge Scheduler
#' schedule group
#'
#' @description
#' Removes one or more tags from the specified EventBridge Scheduler schedule group.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_untag_resource/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the schedule group from which you are
#' removing tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_untag_resource
eventbridgescheduler_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .eventbridgescheduler$untag_resource_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$untag_resource <- eventbridgescheduler_untag_resource

#' Updates the specified schedule
#'
#' @description
#' Updates the specified schedule. When you call [`update_schedule`][eventbridgescheduler_update_schedule], EventBridge Scheduler uses all values, including empty values, specified in the request and overrides the existing schedule. This is by design. This means that if you do not set an optional field in your request, that field will be set to its system-default value after the update.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridgescheduler_update_schedule/](https://www.paws-r-sdk.com/docs/eventbridgescheduler_update_schedule/) for full documentation.
#'
#' @param ActionAfterCompletion Specifies the action that EventBridge Scheduler applies to the schedule
#' after the schedule completes invoking the target.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. If you do not specify a client token, EventBridge
#' Scheduler uses a randomly generated token for the request to ensure
#' idempotency.
#' @param Description The description you specify for the schedule.
#' @param EndDate The date, in UTC, before which the schedule can invoke its target.
#' Depending on the schedule's recurrence expression, invocations might
#' stop on, or before, the `EndDate` you specify. EventBridge Scheduler
#' ignores `EndDate` for one-time schedules.
#' @param FlexibleTimeWindow &#91;required&#93; Allows you to configure a time window during which EventBridge Scheduler
#' invokes the schedule.
#' @param GroupName The name of the schedule group with which the schedule is associated.
#' You must provide this value in order for EventBridge Scheduler to find
#' the schedule you want to update. If you omit this value, EventBridge
#' Scheduler assumes the group is associated to the default group.
#' @param KmsKeyArn The ARN for the customer managed KMS key that that you want EventBridge
#' Scheduler to use to encrypt and decrypt your data.
#' @param Name &#91;required&#93; The name of the schedule that you are updating.
#' @param ScheduleExpression &#91;required&#93; The expression that defines when the schedule runs. The following
#' formats are supported.
#' 
#' -   `at` expression - `at(yyyy-mm-ddThh:mm:ss)`
#' 
#' -   `rate` expression - `rate(value unit)`
#' 
#' -   `cron` expression - `cron(fields)`
#' 
#' You can use `at` expressions to create one-time schedules that invoke a
#' target once, at the time and in the time zone, that you specify. You can
#' use `rate` and `cron` expressions to create recurring schedules.
#' Rate-based schedules are useful when you want to invoke a target at
#' regular intervals, such as every 15 minutes or every five days.
#' Cron-based schedules are useful when you want to invoke a target
#' periodically at a specific time, such as at 8:00 am (UTC+0) every 1st
#' day of the month.
#' 
#' A `cron` expression consists of six fields separated by white spaces:
#' `(minutes hours day_of_month month day_of_week year)`.
#' 
#' A `rate` expression consists of a *value* as a positive integer, and a
#' *unit* with the following options: `minute` | `minutes` | `hour` |
#' `hours` | `day` | `days`
#' 
#' For more information and examples, see [Schedule types on EventBridge
#' Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html)
#' in the *EventBridge Scheduler User Guide*.
#' @param ScheduleExpressionTimezone The timezone in which the scheduling expression is evaluated.
#' @param StartDate The date, in UTC, after which the schedule can begin invoking its
#' target. Depending on the schedule's recurrence expression, invocations
#' might occur on, or after, the `StartDate` you specify. EventBridge
#' Scheduler ignores `StartDate` for one-time schedules.
#' @param State Specifies whether the schedule is enabled or disabled.
#' @param Target &#91;required&#93; The schedule target. You can use this operation to change the target
#' that your schedule invokes.
#'
#' @keywords internal
#'
#' @rdname eventbridgescheduler_update_schedule
eventbridgescheduler_update_schedule <- function(ActionAfterCompletion = NULL, ClientToken = NULL, Description = NULL, EndDate = NULL, FlexibleTimeWindow, GroupName = NULL, KmsKeyArn = NULL, Name, ScheduleExpression, ScheduleExpressionTimezone = NULL, StartDate = NULL, State = NULL, Target) {
  op <- new_operation(
    name = "UpdateSchedule",
    http_method = "PUT",
    http_path = "/schedules/{Name}",
    host_prefix = "",
    paginator = list()
  )
  input <- .eventbridgescheduler$update_schedule_input(ActionAfterCompletion = ActionAfterCompletion, ClientToken = ClientToken, Description = Description, EndDate = EndDate, FlexibleTimeWindow = FlexibleTimeWindow, GroupName = GroupName, KmsKeyArn = KmsKeyArn, Name = Name, ScheduleExpression = ScheduleExpression, ScheduleExpressionTimezone = ScheduleExpressionTimezone, StartDate = StartDate, State = State, Target = Target)
  output <- .eventbridgescheduler$update_schedule_output()
  config <- get_config()
  svc <- .eventbridgescheduler$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridgescheduler$operations$update_schedule <- eventbridgescheduler_update_schedule
