% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_signal_workflow_execution}
\alias{swf_signal_workflow_execution}
\title{Records a WorkflowExecutionSignaled event in the workflow execution
history and creates a decision task for the workflow execution
identified by the given domain, workflowId and runId}
\usage{
swf_signal_workflow_execution(
  domain,
  workflowId,
  runId = NULL,
  signalName,
  input = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain containing the workflow execution to signal.}

\item{workflowId}{[required] The workflowId of the workflow execution to signal.}

\item{runId}{The runId of the workflow execution to signal.}

\item{signalName}{[required] The name of the signal. This name must be meaningful to the target
workflow.}

\item{input}{Data to attach to the \code{WorkflowExecutionSignaled} event in the target
workflow execution's history.}
}
\description{
Records a \code{WorkflowExecutionSignaled} event in the workflow execution history and creates a decision task for the workflow execution identified by the given domain, workflowId and runId. The event is recorded with the specified user defined signalName and input (if provided).

See \url{https://www.paws-r-sdk.com/docs/swf_signal_workflow_execution/} for full documentation.
}
\keyword{internal}
