% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_list_subscriptions_by_topic}
\alias{sns_list_subscriptions_by_topic}
\title{Returns a list of the subscriptions to a specific topic}
\usage{
sns_list_subscriptions_by_topic(TopicArn, NextToken)
}
\arguments{
\item{TopicArn}{[required] The ARN of the topic for which you wish to find subscriptions.}

\item{NextToken}{Token returned by the previous \code{ListSubscriptionsByTopic} request.}
}
\description{
Returns a list of the subscriptions to a specific topic. Each call
returns a limited list of subscriptions, up to 100. If there are more
subscriptions, a \code{NextToken} is also returned. Use the \code{NextToken}
parameter in a new \code{ListSubscriptionsByTopic} call to get further
results.
}
\details{
This action is throttled at 30 transactions per second (TPS).
}
\section{Request syntax}{
\preformatted{svc$list_subscriptions_by_topic(
  TopicArn = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
