# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include mq_service.R
NULL

#' Creates a broker
#'
#' Creates a broker. Note: This API is asynchronous.
#'
#' @usage
#' mq_create_broker(AutoMinorVersionUpgrade, BrokerName, Configuration,
#'   CreatorRequestId, DeploymentMode, EncryptionOptions, EngineType,
#'   EngineVersion, HostInstanceType, Logs, MaintenanceWindowStartTime,
#'   PubliclyAccessible, SecurityGroups, SubnetIds, Tags, Users)
#'
#' @param AutoMinorVersionUpgrade Required. Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions. The automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.
#' @param BrokerName Required. The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or special characters.
#' @param Configuration A list of information about the configuration.
#' @param CreatorRequestId The unique ID that the requester receives for the created broker. Amazon MQ passes your ID with the API action. Note: We recommend using a Universally Unique Identifier (UUID) for the creatorRequestId. You may omit the creatorRequestId if your application doesn't require idempotency.
#' @param DeploymentMode Required. The deployment mode of the broker.
#' @param EncryptionOptions Encryption options for the broker.
#' @param EngineType Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
#' @param EngineVersion Required. The version of the broker engine. For a list of supported engine versions, see https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
#' @param HostInstanceType Required. The broker's instance type.
#' @param Logs Enables Amazon CloudWatch logging for brokers.
#' @param MaintenanceWindowStartTime The parameters that determine the WeeklyStartTime.
#' @param PubliclyAccessible Required. Enables connections from applications outside of the VPC that hosts the broker's subnets.
#' @param SecurityGroups The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
#' @param SubnetIds The list of groups (2 maximum) that define which subnets and IP ranges the broker can use from different Availability Zones. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment requires two subnets.
#' @param Tags Create tags when creating the broker.
#' @param Users Required. The list of ActiveMQ users (persons or applications) who can access queues and topics. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#'
#' @section Request syntax:
#' ```
#' svc$create_broker(
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   BrokerName = "string",
#'   Configuration = list(
#'     Id = "string",
#'     Revision = 123
#'   ),
#'   CreatorRequestId = "string",
#'   DeploymentMode = "SINGLE_INSTANCE"|"ACTIVE_STANDBY_MULTI_AZ",
#'   EncryptionOptions = list(
#'     KmsKeyId = "string",
#'     UseAwsOwnedKey = TRUE|FALSE
#'   ),
#'   EngineType = "ACTIVEMQ",
#'   EngineVersion = "string",
#'   HostInstanceType = "string",
#'   Logs = list(
#'     Audit = TRUE|FALSE,
#'     General = TRUE|FALSE
#'   ),
#'   MaintenanceWindowStartTime = list(
#'     DayOfWeek = "MONDAY"|"TUESDAY"|"WEDNESDAY"|"THURSDAY"|"FRIDAY"|"SATURDAY"|"SUNDAY",
#'     TimeOfDay = "string",
#'     TimeZone = "string"
#'   ),
#'   PubliclyAccessible = TRUE|FALSE,
#'   SecurityGroups = list(
#'     "string"
#'   ),
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   ),
#'   Users = list(
#'     list(
#'       ConsoleAccess = TRUE|FALSE,
#'       Groups = list(
#'         "string"
#'       ),
#'       Password = "string",
#'       Username = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_create_broker
mq_create_broker <- function(AutoMinorVersionUpgrade = NULL, BrokerName = NULL, Configuration = NULL, CreatorRequestId = NULL, DeploymentMode = NULL, EncryptionOptions = NULL, EngineType = NULL, EngineVersion = NULL, HostInstanceType = NULL, Logs = NULL, MaintenanceWindowStartTime = NULL, PubliclyAccessible = NULL, SecurityGroups = NULL, SubnetIds = NULL, Tags = NULL, Users = NULL) {
  op <- new_operation(
    name = "CreateBroker",
    http_method = "POST",
    http_path = "/v1/brokers",
    paginator = list()
  )
  input <- .mq$create_broker_input(AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, BrokerName = BrokerName, Configuration = Configuration, CreatorRequestId = CreatorRequestId, DeploymentMode = DeploymentMode, EncryptionOptions = EncryptionOptions, EngineType = EngineType, EngineVersion = EngineVersion, HostInstanceType = HostInstanceType, Logs = Logs, MaintenanceWindowStartTime = MaintenanceWindowStartTime, PubliclyAccessible = PubliclyAccessible, SecurityGroups = SecurityGroups, SubnetIds = SubnetIds, Tags = Tags, Users = Users)
  output <- .mq$create_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_broker <- mq_create_broker

#' Creates a new configuration for the specified configuration name
#'
#' Creates a new configuration for the specified configuration name. Amazon MQ uses the default configuration (the engine type and version).
#'
#' @usage
#' mq_create_configuration(EngineType, EngineVersion, Name, Tags)
#'
#' @param EngineType Required. The type of broker engine. Note: Currently, Amazon MQ supports only ACTIVEMQ.
#' @param EngineVersion Required. The version of the broker engine. For a list of supported engine versions, see https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
#' @param Name Required. The name of the configuration. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 1-150 characters long.
#' @param Tags Create tags when creating the configuration.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration(
#'   EngineType = "ACTIVEMQ",
#'   EngineVersion = "string",
#'   Name = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_create_configuration
mq_create_configuration <- function(EngineType = NULL, EngineVersion = NULL, Name = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfiguration",
    http_method = "POST",
    http_path = "/v1/configurations",
    paginator = list()
  )
  input <- .mq$create_configuration_input(EngineType = EngineType, EngineVersion = EngineVersion, Name = Name, Tags = Tags)
  output <- .mq$create_configuration_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_configuration <- mq_create_configuration

#' Add a tag to a resource
#'
#' Add a tag to a resource.
#'
#' @usage
#' mq_create_tags(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource tag.
#' @param Tags The key-value pair for the resource tag.
#'
#' @section Request syntax:
#' ```
#' svc$create_tags(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_create_tags
mq_create_tags <- function(ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .mq$create_tags_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .mq$create_tags_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_tags <- mq_create_tags

#' Creates an ActiveMQ user
#'
#' Creates an ActiveMQ user.
#'
#' @usage
#' mq_create_user(BrokerId, ConsoleAccess, Groups, Password, Username)
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param ConsoleAccess Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
#' @param Groups The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#' @param Password Required. The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas.
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#'
#' @section Request syntax:
#' ```
#' svc$create_user(
#'   BrokerId = "string",
#'   ConsoleAccess = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   Password = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_create_user
mq_create_user <- function(BrokerId, ConsoleAccess = NULL, Groups = NULL, Password = NULL, Username) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$create_user_input(BrokerId = BrokerId, ConsoleAccess = ConsoleAccess, Groups = Groups, Password = Password, Username = Username)
  output <- .mq$create_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$create_user <- mq_create_user

#' Deletes a broker
#'
#' Deletes a broker. Note: This API is asynchronous.
#'
#' @usage
#' mq_delete_broker(BrokerId)
#'
#' @param BrokerId &#91;required&#93; The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or special characters.
#'
#' @section Request syntax:
#' ```
#' svc$delete_broker(
#'   BrokerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_delete_broker
mq_delete_broker <- function(BrokerId) {
  op <- new_operation(
    name = "DeleteBroker",
    http_method = "DELETE",
    http_path = "/v1/brokers/{broker-id}",
    paginator = list()
  )
  input <- .mq$delete_broker_input(BrokerId = BrokerId)
  output <- .mq$delete_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$delete_broker <- mq_delete_broker

#' Removes a tag from a resource
#'
#' Removes a tag from a resource.
#'
#' @usage
#' mq_delete_tags(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource tag.
#' @param TagKeys &#91;required&#93; An array of tag keys to delete
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_delete_tags
mq_delete_tags <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "DELETE",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .mq$delete_tags_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .mq$delete_tags_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$delete_tags <- mq_delete_tags

#' Deletes an ActiveMQ user
#'
#' Deletes an ActiveMQ user.
#'
#' @usage
#' mq_delete_user(BrokerId, Username)
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user(
#'   BrokerId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_delete_user
mq_delete_user <- function(BrokerId, Username) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$delete_user_input(BrokerId = BrokerId, Username = Username)
  output <- .mq$delete_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$delete_user <- mq_delete_user

#' Returns information about the specified broker
#'
#' Returns information about the specified broker.
#'
#' @usage
#' mq_describe_broker(BrokerId)
#'
#' @param BrokerId &#91;required&#93; The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or special characters.
#'
#' @section Request syntax:
#' ```
#' svc$describe_broker(
#'   BrokerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_describe_broker
mq_describe_broker <- function(BrokerId) {
  op <- new_operation(
    name = "DescribeBroker",
    http_method = "GET",
    http_path = "/v1/brokers/{broker-id}",
    paginator = list()
  )
  input <- .mq$describe_broker_input(BrokerId = BrokerId)
  output <- .mq$describe_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_broker <- mq_describe_broker

#' Describe available engine types and versions
#'
#' Describe available engine types and versions.
#'
#' @usage
#' mq_describe_broker_engine_types(EngineType, MaxResults, NextToken)
#'
#' @param EngineType Filter response by engine type.
#' @param MaxResults The maximum number of engine types that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.
#'
#' @section Request syntax:
#' ```
#' svc$describe_broker_engine_types(
#'   EngineType = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_describe_broker_engine_types
mq_describe_broker_engine_types <- function(EngineType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBrokerEngineTypes",
    http_method = "GET",
    http_path = "/v1/broker-engine-types",
    paginator = list()
  )
  input <- .mq$describe_broker_engine_types_input(EngineType = EngineType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$describe_broker_engine_types_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_broker_engine_types <- mq_describe_broker_engine_types

#' Describe available broker instance options
#'
#' Describe available broker instance options.
#'
#' @usage
#' mq_describe_broker_instance_options(EngineType, HostInstanceType,
#'   MaxResults, NextToken)
#'
#' @param EngineType Filter response by engine type.
#' @param HostInstanceType Filter response by host instance type.
#' @param MaxResults The maximum number of instance options that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.
#'
#' @section Request syntax:
#' ```
#' svc$describe_broker_instance_options(
#'   EngineType = "string",
#'   HostInstanceType = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_describe_broker_instance_options
mq_describe_broker_instance_options <- function(EngineType = NULL, HostInstanceType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBrokerInstanceOptions",
    http_method = "GET",
    http_path = "/v1/broker-instance-options",
    paginator = list()
  )
  input <- .mq$describe_broker_instance_options_input(EngineType = EngineType, HostInstanceType = HostInstanceType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$describe_broker_instance_options_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_broker_instance_options <- mq_describe_broker_instance_options

#' Returns information about the specified configuration
#'
#' Returns information about the specified configuration.
#'
#' @usage
#' mq_describe_configuration(ConfigurationId)
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration(
#'   ConfigurationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_describe_configuration
mq_describe_configuration <- function(ConfigurationId) {
  op <- new_operation(
    name = "DescribeConfiguration",
    http_method = "GET",
    http_path = "/v1/configurations/{configuration-id}",
    paginator = list()
  )
  input <- .mq$describe_configuration_input(ConfigurationId = ConfigurationId)
  output <- .mq$describe_configuration_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_configuration <- mq_describe_configuration

#' Returns the specified configuration revision for the specified
#' configuration
#'
#' Returns the specified configuration revision for the specified configuration.
#'
#' @usage
#' mq_describe_configuration_revision(ConfigurationId,
#'   ConfigurationRevision)
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#' @param ConfigurationRevision &#91;required&#93; The revision of the configuration.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_revision(
#'   ConfigurationId = "string",
#'   ConfigurationRevision = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_describe_configuration_revision
mq_describe_configuration_revision <- function(ConfigurationId, ConfigurationRevision) {
  op <- new_operation(
    name = "DescribeConfigurationRevision",
    http_method = "GET",
    http_path = "/v1/configurations/{configuration-id}/revisions/{configuration-revision}",
    paginator = list()
  )
  input <- .mq$describe_configuration_revision_input(ConfigurationId = ConfigurationId, ConfigurationRevision = ConfigurationRevision)
  output <- .mq$describe_configuration_revision_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_configuration_revision <- mq_describe_configuration_revision

#' Returns information about an ActiveMQ user
#'
#' Returns information about an ActiveMQ user.
#'
#' @usage
#' mq_describe_user(BrokerId, Username)
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param Username &#91;required&#93; The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#'
#' @section Request syntax:
#' ```
#' svc$describe_user(
#'   BrokerId = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_describe_user
mq_describe_user <- function(BrokerId, Username) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "GET",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$describe_user_input(BrokerId = BrokerId, Username = Username)
  output <- .mq$describe_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$describe_user <- mq_describe_user

#' Returns a list of all brokers
#'
#' Returns a list of all brokers.
#'
#' @usage
#' mq_list_brokers(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of brokers that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.
#'
#' @section Request syntax:
#' ```
#' svc$list_brokers(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_list_brokers
mq_list_brokers <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListBrokers",
    http_method = "GET",
    http_path = "/v1/brokers",
    paginator = list()
  )
  input <- .mq$list_brokers_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_brokers_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_brokers <- mq_list_brokers

#' Returns a list of all revisions for the specified configuration
#'
#' Returns a list of all revisions for the specified configuration.
#'
#' @usage
#' mq_list_configuration_revisions(ConfigurationId, MaxResults, NextToken)
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#' @param MaxResults The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.
#'
#' @section Request syntax:
#' ```
#' svc$list_configuration_revisions(
#'   ConfigurationId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_list_configuration_revisions
mq_list_configuration_revisions <- function(ConfigurationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurationRevisions",
    http_method = "GET",
    http_path = "/v1/configurations/{configuration-id}/revisions",
    paginator = list()
  )
  input <- .mq$list_configuration_revisions_input(ConfigurationId = ConfigurationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_configuration_revisions_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_configuration_revisions <- mq_list_configuration_revisions

#' Returns a list of all configurations
#'
#' Returns a list of all configurations.
#'
#' @usage
#' mq_list_configurations(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of configurations that Amazon MQ can return per page (20 by default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.
#'
#' @section Request syntax:
#' ```
#' svc$list_configurations(
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_list_configurations
mq_list_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurations",
    http_method = "GET",
    http_path = "/v1/configurations",
    paginator = list()
  )
  input <- .mq$list_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_configurations_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_configurations <- mq_list_configurations

#' Lists tags for a resource
#'
#' Lists tags for a resource.
#'
#' @usage
#' mq_list_tags(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource tag.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_list_tags
mq_list_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .mq$list_tags_input(ResourceArn = ResourceArn)
  output <- .mq$list_tags_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_tags <- mq_list_tags

#' Returns a list of all ActiveMQ users
#'
#' Returns a list of all ActiveMQ users.
#'
#' @usage
#' mq_list_users(BrokerId, MaxResults, NextToken)
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param MaxResults The maximum number of ActiveMQ users that can be returned per page (20 by default). This value must be an integer from 5 to 100.
#' @param NextToken The token that specifies the next page of results Amazon MQ should return. To request the first page, leave nextToken empty.
#'
#' @section Request syntax:
#' ```
#' svc$list_users(
#'   BrokerId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_list_users
mq_list_users <- function(BrokerId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/v1/brokers/{broker-id}/users",
    paginator = list()
  )
  input <- .mq$list_users_input(BrokerId = BrokerId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .mq$list_users_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$list_users <- mq_list_users

#' Reboots a broker
#'
#' Reboots a broker. Note: This API is asynchronous.
#'
#' @usage
#' mq_reboot_broker(BrokerId)
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_broker(
#'   BrokerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_reboot_broker
mq_reboot_broker <- function(BrokerId) {
  op <- new_operation(
    name = "RebootBroker",
    http_method = "POST",
    http_path = "/v1/brokers/{broker-id}/reboot",
    paginator = list()
  )
  input <- .mq$reboot_broker_input(BrokerId = BrokerId)
  output <- .mq$reboot_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$reboot_broker <- mq_reboot_broker

#' Adds a pending configuration change to a broker
#'
#' Adds a pending configuration change to a broker.
#'
#' @usage
#' mq_update_broker(AutoMinorVersionUpgrade, BrokerId, Configuration,
#'   EngineVersion, Logs)
#'
#' @param AutoMinorVersionUpgrade Enables automatic upgrades to new minor versions for brokers, as Apache releases the versions. The automatic upgrades occur during the maintenance window of the broker or after a manual broker reboot.
#' @param BrokerId &#91;required&#93; The name of the broker. This value must be unique in your AWS account, 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain whitespaces, brackets, wildcard characters, or special characters.
#' @param Configuration A list of information about the configuration.
#' @param EngineVersion The version of the broker engine. For a list of supported engine versions, see https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html
#' @param Logs Enables Amazon CloudWatch logging for brokers.
#'
#' @section Request syntax:
#' ```
#' svc$update_broker(
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   BrokerId = "string",
#'   Configuration = list(
#'     Id = "string",
#'     Revision = 123
#'   ),
#'   EngineVersion = "string",
#'   Logs = list(
#'     Audit = TRUE|FALSE,
#'     General = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_update_broker
mq_update_broker <- function(AutoMinorVersionUpgrade = NULL, BrokerId, Configuration = NULL, EngineVersion = NULL, Logs = NULL) {
  op <- new_operation(
    name = "UpdateBroker",
    http_method = "PUT",
    http_path = "/v1/brokers/{broker-id}",
    paginator = list()
  )
  input <- .mq$update_broker_input(AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, BrokerId = BrokerId, Configuration = Configuration, EngineVersion = EngineVersion, Logs = Logs)
  output <- .mq$update_broker_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$update_broker <- mq_update_broker

#' Updates the specified configuration
#'
#' Updates the specified configuration.
#'
#' @usage
#' mq_update_configuration(ConfigurationId, Data, Description)
#'
#' @param ConfigurationId &#91;required&#93; The unique ID that Amazon MQ generates for the configuration.
#' @param Data Required. The base64-encoded XML configuration.
#' @param Description The description of the configuration.
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration(
#'   ConfigurationId = "string",
#'   Data = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_update_configuration
mq_update_configuration <- function(ConfigurationId, Data = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateConfiguration",
    http_method = "PUT",
    http_path = "/v1/configurations/{configuration-id}",
    paginator = list()
  )
  input <- .mq$update_configuration_input(ConfigurationId = ConfigurationId, Data = Data, Description = Description)
  output <- .mq$update_configuration_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$update_configuration <- mq_update_configuration

#' Updates the information for an ActiveMQ user
#'
#' Updates the information for an ActiveMQ user.
#'
#' @usage
#' mq_update_user(BrokerId, ConsoleAccess, Groups, Password, Username)
#'
#' @param BrokerId &#91;required&#93; The unique ID that Amazon MQ generates for the broker.
#' @param ConsoleAccess Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
#' @param Groups The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#' @param Password The password of the user. This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas.
#' @param Username &#91;required&#93; Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
#'
#' @section Request syntax:
#' ```
#' svc$update_user(
#'   BrokerId = "string",
#'   ConsoleAccess = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   Password = "string",
#'   Username = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname mq_update_user
mq_update_user <- function(BrokerId, ConsoleAccess = NULL, Groups = NULL, Password = NULL, Username) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "PUT",
    http_path = "/v1/brokers/{broker-id}/users/{username}",
    paginator = list()
  )
  input <- .mq$update_user_input(BrokerId = BrokerId, ConsoleAccess = ConsoleAccess, Groups = Groups, Password = Password, Username = Username)
  output <- .mq$update_user_output()
  config <- get_config()
  svc <- .mq$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.mq$operations$update_user <- mq_update_user
