% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_list_subscriptions}
\alias{sns_list_subscriptions}
\title{Returns a list of the requester's subscriptions}
\usage{
sns_list_subscriptions(NextToken)
}
\arguments{
\item{NextToken}{Token returned by the previous
\code{\link[=sns_list_subscriptions]{list_subscriptions}} request.}
}
\value{
A list with the following syntax:\preformatted{list(
  Subscriptions = list(
    list(
      SubscriptionArn = "string",
      Owner = "string",
      Protocol = "string",
      Endpoint = "string",
      TopicArn = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of the requester's subscriptions. Each call returns a
limited list of subscriptions, up to 100. If there are more
subscriptions, a \code{NextToken} is also returned. Use the \code{NextToken}
parameter in a new \code{\link[=sns_list_subscriptions]{list_subscriptions}} call
to get further results.

This action is throttled at 30 transactions per second (TPS).
}
\section{Request syntax}{
\preformatted{svc$list_subscriptions(
  NextToken = "string"
)
}
}

\keyword{internal}
