% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_create_configuration}
\alias{mq_create_configuration}
\title{Creates a new configuration for the specified configuration name}
\usage{
mq_create_configuration(AuthenticationStrategy, EngineType,
  EngineVersion, Name, Tags)
}
\arguments{
\item{AuthenticationStrategy}{The authentication strategy associated with the configuration.}

\item{EngineType}{Required. The type of broker engine. Note: Currently, Amazon MQ supports
ACTIVEMQ and RABBITMQ.}

\item{EngineVersion}{Required. The version of the broker engine. For a list of supported
engine versions, see
https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html}

\item{Name}{Required. The name of the configuration. This value can contain only
alphanumeric characters, dashes, periods, underscores, and tildes (- .
_ ~). This value must be 1-150 characters long.}

\item{Tags}{Create tags when creating the configuration.}
}
\value{
A list with the following syntax:\preformatted{list(
  Arn = "string",
  AuthenticationStrategy = "SIMPLE"|"LDAP",
  Created = as.POSIXct(
    "2015-01-01"
  ),
  Id = "string",
  LatestRevision = list(
    Created = as.POSIXct(
      "2015-01-01"
    ),
    Description = "string",
    Revision = 123
  ),
  Name = "string"
)
}
}
\description{
Creates a new configuration for the specified configuration name. Amazon
MQ uses the default configuration (the engine type and version).
}
\section{Request syntax}{
\preformatted{svc$create_configuration(
  AuthenticationStrategy = "SIMPLE"|"LDAP",
  EngineType = "ACTIVEMQ"|"RABBITMQ",
  EngineVersion = "string",
  Name = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
