# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include swf_service.R
NULL

#' Returns the number of closed workflow executions within the given domain
#' that meet the specified filtering criteria
#'
#' Returns the number of closed workflow executions within the given domain
#' that meet the specified filtering criteria.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `tagFilter.tag`: String constraint. The key is
#'         `swf:tagFilter.tag`.
#' 
#'     -   `typeFilter.name`: String constraint. The key is
#'         `swf:typeFilter.name`.
#' 
#'     -   `typeFilter.version`: String constraint. The key is
#'         `swf:typeFilter.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_count_closed_workflow_executions(domain, startTimeFilter,
#'   closeTimeFilter, executionFilter, typeFilter, tagFilter,
#'   closeStatusFilter)
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow executions to count.
#' @param startTimeFilter If specified, only workflow executions that meet the start time criteria
#' of the filter are counted.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param closeTimeFilter If specified, only workflow executions that meet the close time criteria
#' of the filter are counted.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param executionFilter If specified, only workflow executions matching the `WorkflowId` in the
#' filter are counted.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param typeFilter If specified, indicates the type of the workflow executions to be
#' counted.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have a tag that matches the filter
#' are counted.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param closeStatusFilter If specified, only workflow executions that match this close status are
#' counted. This filter has an affect only if `executionStatus` is
#' specified as `CLOSED`.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#'
#' @section Request syntax:
#' ```
#' svc$count_closed_workflow_executions(
#'   domain = "string",
#'   startTimeFilter = list(
#'     oldestDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   closeTimeFilter = list(
#'     oldestDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   executionFilter = list(
#'     workflowId = "string"
#'   ),
#'   typeFilter = list(
#'     name = "string",
#'     version = "string"
#'   ),
#'   tagFilter = list(
#'     tag = "string"
#'   ),
#'   closeStatusFilter = list(
#'     status = "COMPLETED"|"FAILED"|"CANCELED"|"TERMINATED"|"CONTINUED_AS_NEW"|"TIMED_OUT"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_count_closed_workflow_executions
swf_count_closed_workflow_executions <- function(domain, startTimeFilter = NULL, closeTimeFilter = NULL, executionFilter = NULL, typeFilter = NULL, tagFilter = NULL, closeStatusFilter = NULL) {
  op <- new_operation(
    name = "CountClosedWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$count_closed_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, closeTimeFilter = closeTimeFilter, executionFilter = executionFilter, typeFilter = typeFilter, tagFilter = tagFilter, closeStatusFilter = closeStatusFilter)
  output <- .swf$count_closed_workflow_executions_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_closed_workflow_executions <- swf_count_closed_workflow_executions

#' Returns the number of open workflow executions within the given domain
#' that meet the specified filtering criteria
#'
#' Returns the number of open workflow executions within the given domain
#' that meet the specified filtering criteria.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `tagFilter.tag`: String constraint. The key is
#'         `swf:tagFilter.tag`.
#' 
#'     -   `typeFilter.name`: String constraint. The key is
#'         `swf:typeFilter.name`.
#' 
#'     -   `typeFilter.version`: String constraint. The key is
#'         `swf:typeFilter.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_count_open_workflow_executions(domain, startTimeFilter, typeFilter,
#'   tagFilter, executionFilter)
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow executions to count.
#' @param startTimeFilter &#91;required&#93; Specifies the start time criteria that workflow executions must meet in
#' order to be counted.
#' @param typeFilter Specifies the type of the workflow executions to be counted.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have a tag that matches the filter
#' are counted.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param executionFilter If specified, only workflow executions matching the `WorkflowId` in the
#' filter are counted.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#'
#' @section Request syntax:
#' ```
#' svc$count_open_workflow_executions(
#'   domain = "string",
#'   startTimeFilter = list(
#'     oldestDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   typeFilter = list(
#'     name = "string",
#'     version = "string"
#'   ),
#'   tagFilter = list(
#'     tag = "string"
#'   ),
#'   executionFilter = list(
#'     workflowId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_count_open_workflow_executions
swf_count_open_workflow_executions <- function(domain, startTimeFilter, typeFilter = NULL, tagFilter = NULL, executionFilter = NULL) {
  op <- new_operation(
    name = "CountOpenWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$count_open_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, typeFilter = typeFilter, tagFilter = tagFilter, executionFilter = executionFilter)
  output <- .swf$count_open_workflow_executions_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_open_workflow_executions <- swf_count_open_workflow_executions

#' Returns the estimated number of activity tasks in the specified task
#' list
#'
#' Returns the estimated number of activity tasks in the specified task
#' list. The count returned is an approximation and isn\'t guaranteed to be
#' exact. If you specify a task list that no activity task was ever
#' scheduled in then `0` is returned.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the `taskList.name` parameter by using a `Condition`
#'     element with the `swf:taskList.name` key to allow the action to
#'     access only certain task lists.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_count_pending_activity_tasks(domain, taskList)
#'
#' @param domain &#91;required&#93; The name of the domain that contains the task list.
#' @param taskList &#91;required&#93; The name of the task list.
#'
#' @section Request syntax:
#' ```
#' svc$count_pending_activity_tasks(
#'   domain = "string",
#'   taskList = list(
#'     name = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_count_pending_activity_tasks
swf_count_pending_activity_tasks <- function(domain, taskList) {
  op <- new_operation(
    name = "CountPendingActivityTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$count_pending_activity_tasks_input(domain = domain, taskList = taskList)
  output <- .swf$count_pending_activity_tasks_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_pending_activity_tasks <- swf_count_pending_activity_tasks

#' Returns the estimated number of decision tasks in the specified task
#' list
#'
#' Returns the estimated number of decision tasks in the specified task
#' list. The count returned is an approximation and isn\'t guaranteed to be
#' exact. If you specify a task list that no decision task was ever
#' scheduled in then `0` is returned.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the `taskList.name` parameter by using a `Condition`
#'     element with the `swf:taskList.name` key to allow the action to
#'     access only certain task lists.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_count_pending_decision_tasks(domain, taskList)
#'
#' @param domain &#91;required&#93; The name of the domain that contains the task list.
#' @param taskList &#91;required&#93; The name of the task list.
#'
#' @section Request syntax:
#' ```
#' svc$count_pending_decision_tasks(
#'   domain = "string",
#'   taskList = list(
#'     name = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_count_pending_decision_tasks
swf_count_pending_decision_tasks <- function(domain, taskList) {
  op <- new_operation(
    name = "CountPendingDecisionTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$count_pending_decision_tasks_input(domain = domain, taskList = taskList)
  output <- .swf$count_pending_decision_tasks_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$count_pending_decision_tasks <- swf_count_pending_decision_tasks

#' Deprecates the specified _activity type_
#'
#' Deprecates the specified *activity type*. After an activity type has
#' been deprecated, you cannot create new tasks of that activity type.
#' Tasks of this type that were scheduled before the type was deprecated
#' continue to run.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `activityType.name`: String constraint. The key is
#'         `swf:activityType.name`.
#' 
#'     -   `activityType.version`: String constraint. The key is
#'         `swf:activityType.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_deprecate_activity_type(domain, activityType)
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity type is registered.
#' @param activityType &#91;required&#93; The activity type to deprecate.
#'
#' @section Request syntax:
#' ```
#' svc$deprecate_activity_type(
#'   domain = "string",
#'   activityType = list(
#'     name = "string",
#'     version = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_deprecate_activity_type
swf_deprecate_activity_type <- function(domain, activityType) {
  op <- new_operation(
    name = "DeprecateActivityType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$deprecate_activity_type_input(domain = domain, activityType = activityType)
  output <- .swf$deprecate_activity_type_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$deprecate_activity_type <- swf_deprecate_activity_type

#' Deprecates the specified domain
#'
#' Deprecates the specified domain. After a domain has been deprecated it
#' cannot be used to create new workflow executions or register new types.
#' However, you can still use visibility actions on this domain.
#' Deprecating a domain also deprecates all activity and workflow types
#' registered in the domain. Executions that were started before the domain
#' was deprecated continues to run.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_deprecate_domain(name)
#'
#' @param name &#91;required&#93; The name of the domain to deprecate.
#'
#' @section Request syntax:
#' ```
#' svc$deprecate_domain(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_deprecate_domain
swf_deprecate_domain <- function(name) {
  op <- new_operation(
    name = "DeprecateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$deprecate_domain_input(name = name)
  output <- .swf$deprecate_domain_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$deprecate_domain <- swf_deprecate_domain

#' Deprecates the specified _workflow type_
#'
#' Deprecates the specified *workflow type*. After a workflow type has been
#' deprecated, you cannot create new executions of that type. Executions
#' that were started before the type was deprecated continues to run. A
#' deprecated workflow type may still be used when calling visibility
#' actions.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `workflowType.name`: String constraint. The key is
#'         `swf:workflowType.name`.
#' 
#'     -   `workflowType.version`: String constraint. The key is
#'         `swf:workflowType.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_deprecate_workflow_type(domain, workflowType)
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow type is registered.
#' @param workflowType &#91;required&#93; The workflow type to deprecate.
#'
#' @section Request syntax:
#' ```
#' svc$deprecate_workflow_type(
#'   domain = "string",
#'   workflowType = list(
#'     name = "string",
#'     version = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_deprecate_workflow_type
swf_deprecate_workflow_type <- function(domain, workflowType) {
  op <- new_operation(
    name = "DeprecateWorkflowType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$deprecate_workflow_type_input(domain = domain, workflowType = workflowType)
  output <- .swf$deprecate_workflow_type_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$deprecate_workflow_type <- swf_deprecate_workflow_type

#' Returns information about the specified activity type
#'
#' Returns information about the specified activity type. This includes
#' configuration settings provided when the type was registered and other
#' general information about the type.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `activityType.name`: String constraint. The key is
#'         `swf:activityType.name`.
#' 
#'     -   `activityType.version`: String constraint. The key is
#'         `swf:activityType.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_describe_activity_type(domain, activityType)
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity type is registered.
#' @param activityType &#91;required&#93; The activity type to get information about. Activity types are
#' identified by the `name` and `version` that were supplied when the
#' activity was registered.
#'
#' @section Request syntax:
#' ```
#' svc$describe_activity_type(
#'   domain = "string",
#'   activityType = list(
#'     name = "string",
#'     version = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_describe_activity_type
swf_describe_activity_type <- function(domain, activityType) {
  op <- new_operation(
    name = "DescribeActivityType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$describe_activity_type_input(domain = domain, activityType = activityType)
  output <- .swf$describe_activity_type_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_activity_type <- swf_describe_activity_type

#' Returns information about the specified domain, including description
#' and status
#'
#' Returns information about the specified domain, including description
#' and status.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_describe_domain(name)
#'
#' @param name &#91;required&#93; The name of the domain to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_domain(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_describe_domain
swf_describe_domain <- function(name) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$describe_domain_input(name = name)
  output <- .swf$describe_domain_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_domain <- swf_describe_domain

#' Returns information about the specified workflow execution including its
#' type and some statistics
#'
#' Returns information about the specified workflow execution including its
#' type and some statistics.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_describe_workflow_execution(domain, execution)
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution.
#' @param execution &#91;required&#93; The workflow execution to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_workflow_execution(
#'   domain = "string",
#'   execution = list(
#'     workflowId = "string",
#'     runId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_describe_workflow_execution
swf_describe_workflow_execution <- function(domain, execution) {
  op <- new_operation(
    name = "DescribeWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$describe_workflow_execution_input(domain = domain, execution = execution)
  output <- .swf$describe_workflow_execution_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_workflow_execution <- swf_describe_workflow_execution

#' Returns information about the specified _workflow type_
#'
#' Returns information about the specified *workflow type*. This includes
#' configuration settings specified when the type was registered and other
#' information such as creation date, current status, etc.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `workflowType.name`: String constraint. The key is
#'         `swf:workflowType.name`.
#' 
#'     -   `workflowType.version`: String constraint. The key is
#'         `swf:workflowType.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_describe_workflow_type(domain, workflowType)
#'
#' @param domain &#91;required&#93; The name of the domain in which this workflow type is registered.
#' @param workflowType &#91;required&#93; The workflow type to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_workflow_type(
#'   domain = "string",
#'   workflowType = list(
#'     name = "string",
#'     version = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_describe_workflow_type
swf_describe_workflow_type <- function(domain, workflowType) {
  op <- new_operation(
    name = "DescribeWorkflowType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$describe_workflow_type_input(domain = domain, workflowType = workflowType)
  output <- .swf$describe_workflow_type_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$describe_workflow_type <- swf_describe_workflow_type

#' Returns the history of the specified workflow execution
#'
#' Returns the history of the specified workflow execution. The results may
#' be split into multiple pages. To retrieve subsequent pages, make the
#' call again using the `nextPageToken` returned by the initial call.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_get_workflow_execution_history(domain, execution, nextPageToken,
#'   maximumPageSize, reverseOrder)
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution.
#' @param execution &#91;required&#93; Specifies the workflow execution for which to return the history.
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the events in reverse order. By default the
#' results are returned in ascending order of the `eventTimeStamp` of the
#' events.
#'
#' @section Request syntax:
#' ```
#' svc$get_workflow_execution_history(
#'   domain = "string",
#'   execution = list(
#'     workflowId = "string",
#'     runId = "string"
#'   ),
#'   nextPageToken = "string",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_get_workflow_execution_history
swf_get_workflow_execution_history <- function(domain, execution, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "GetWorkflowExecutionHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$get_workflow_execution_history_input(domain = domain, execution = execution, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$get_workflow_execution_history_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$get_workflow_execution_history <- swf_get_workflow_execution_history

#' Returns information about all activities registered in the specified
#' domain that match the specified name and registration status
#'
#' Returns information about all activities registered in the specified
#' domain that match the specified name and registration status. The result
#' includes information like creation date, current status of the activity,
#' etc. The results may be split into multiple pages. To retrieve
#' subsequent pages, make the call again using the `nextPageToken` returned
#' by the initial call.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_list_activity_types(domain, name, registrationStatus, nextPageToken,
#'   maximumPageSize, reverseOrder)
#'
#' @param domain &#91;required&#93; The name of the domain in which the activity types have been registered.
#' @param name If specified, only lists the activity types that have this name.
#' @param registrationStatus &#91;required&#93; Specifies the registration status of the activity types to list.
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default,
#' the results are returned in ascending alphabetical order by `name` of
#' the activity types.
#'
#' @section Request syntax:
#' ```
#' svc$list_activity_types(
#'   domain = "string",
#'   name = "string",
#'   registrationStatus = "REGISTERED"|"DEPRECATED",
#'   nextPageToken = "string",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_list_activity_types
swf_list_activity_types <- function(domain, name = NULL, registrationStatus, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListActivityTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$list_activity_types_input(domain = domain, name = name, registrationStatus = registrationStatus, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_activity_types_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_activity_types <- swf_list_activity_types

#' Returns a list of closed workflow executions in the specified domain
#' that meet the filtering criteria
#'
#' Returns a list of closed workflow executions in the specified domain
#' that meet the filtering criteria. The results may be split into multiple
#' pages. To retrieve subsequent pages, make the call again using the
#' nextPageToken returned by the initial call.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `tagFilter.tag`: String constraint. The key is
#'         `swf:tagFilter.tag`.
#' 
#'     -   `typeFilter.name`: String constraint. The key is
#'         `swf:typeFilter.name`.
#' 
#'     -   `typeFilter.version`: String constraint. The key is
#'         `swf:typeFilter.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_list_closed_workflow_executions(domain, startTimeFilter,
#'   closeTimeFilter, executionFilter, closeStatusFilter, typeFilter,
#'   tagFilter, nextPageToken, maximumPageSize, reverseOrder)
#'
#' @param domain &#91;required&#93; The name of the domain that contains the workflow executions to list.
#' @param startTimeFilter If specified, the workflow executions are included in the returned
#' results based on whether their start times are within the range
#' specified by this filter. Also, if this parameter is specified, the
#' returned results are ordered by their start times.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param closeTimeFilter If specified, the workflow executions are included in the returned
#' results based on whether their close times are within the range
#' specified by this filter. Also, if this parameter is specified, the
#' returned results are ordered by their close times.
#' 
#' `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must
#' specify one of these in a request but not both.
#' @param executionFilter If specified, only workflow executions matching the workflow ID
#' specified in the filter are returned.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param closeStatusFilter If specified, only workflow executions that match this *close status*
#' are listed. For example, if TERMINATED is specified, then only
#' TERMINATED workflow executions are listed.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param typeFilter If specified, only executions of the type specified in the filter are
#' returned.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have the matching tag are listed.
#' 
#' `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are
#' mutually exclusive. You can specify at most one of these in a request.
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default the
#' results are returned in descending order of the start or the close time
#' of the executions.
#'
#' @section Request syntax:
#' ```
#' svc$list_closed_workflow_executions(
#'   domain = "string",
#'   startTimeFilter = list(
#'     oldestDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   closeTimeFilter = list(
#'     oldestDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   executionFilter = list(
#'     workflowId = "string"
#'   ),
#'   closeStatusFilter = list(
#'     status = "COMPLETED"|"FAILED"|"CANCELED"|"TERMINATED"|"CONTINUED_AS_NEW"|"TIMED_OUT"
#'   ),
#'   typeFilter = list(
#'     name = "string",
#'     version = "string"
#'   ),
#'   tagFilter = list(
#'     tag = "string"
#'   ),
#'   nextPageToken = "string",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_list_closed_workflow_executions
swf_list_closed_workflow_executions <- function(domain, startTimeFilter = NULL, closeTimeFilter = NULL, executionFilter = NULL, closeStatusFilter = NULL, typeFilter = NULL, tagFilter = NULL, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListClosedWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$list_closed_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, closeTimeFilter = closeTimeFilter, executionFilter = executionFilter, closeStatusFilter = closeStatusFilter, typeFilter = typeFilter, tagFilter = tagFilter, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_closed_workflow_executions_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_closed_workflow_executions <- swf_list_closed_workflow_executions

#' Returns the list of domains registered in the account
#'
#' Returns the list of domains registered in the account. The results may
#' be split into multiple pages. To retrieve subsequent pages, make the
#' call again using the nextPageToken returned by the initial call.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains. The element must be set to
#'     `arn:aws:swf::AccountID:domain/*`, where *AccountID* is the account
#'     ID, with no dashes.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_list_domains(nextPageToken, registrationStatus, maximumPageSize,
#'   reverseOrder)
#'
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param registrationStatus &#91;required&#93; Specifies the registration status of the domains to list.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default,
#' the results are returned in ascending alphabetical order by `name` of
#' the domains.
#'
#' @section Request syntax:
#' ```
#' svc$list_domains(
#'   nextPageToken = "string",
#'   registrationStatus = "REGISTERED"|"DEPRECATED",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_list_domains
swf_list_domains <- function(nextPageToken = NULL, registrationStatus, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$list_domains_input(nextPageToken = nextPageToken, registrationStatus = registrationStatus, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_domains_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_domains <- swf_list_domains

#' Returns a list of open workflow executions in the specified domain that
#' meet the filtering criteria
#'
#' Returns a list of open workflow executions in the specified domain that
#' meet the filtering criteria. The results may be split into multiple
#' pages. To retrieve subsequent pages, make the call again using the
#' nextPageToken returned by the initial call.
#' 
#' This operation is eventually consistent. The results are best effort and
#' may not exactly reflect recent updates and changes.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `tagFilter.tag`: String constraint. The key is
#'         `swf:tagFilter.tag`.
#' 
#'     -   `typeFilter.name`: String constraint. The key is
#'         `swf:typeFilter.name`.
#' 
#'     -   `typeFilter.version`: String constraint. The key is
#'         `swf:typeFilter.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_list_open_workflow_executions(domain, startTimeFilter, typeFilter,
#'   tagFilter, nextPageToken, maximumPageSize, reverseOrder,
#'   executionFilter)
#'
#' @param domain &#91;required&#93; The name of the domain that contains the workflow executions to list.
#' @param startTimeFilter &#91;required&#93; Workflow executions are included in the returned results based on
#' whether their start times are within the range specified by this filter.
#' @param typeFilter If specified, only executions of the type specified in the filter are
#' returned.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param tagFilter If specified, only executions that have the matching tag are listed.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default the
#' results are returned in descending order of the start time of the
#' executions.
#' @param executionFilter If specified, only workflow executions matching the workflow ID
#' specified in the filter are returned.
#' 
#' `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive.
#' You can specify at most one of these in a request.
#'
#' @section Request syntax:
#' ```
#' svc$list_open_workflow_executions(
#'   domain = "string",
#'   startTimeFilter = list(
#'     oldestDate = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   typeFilter = list(
#'     name = "string",
#'     version = "string"
#'   ),
#'   tagFilter = list(
#'     tag = "string"
#'   ),
#'   nextPageToken = "string",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE,
#'   executionFilter = list(
#'     workflowId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_list_open_workflow_executions
swf_list_open_workflow_executions <- function(domain, startTimeFilter, typeFilter = NULL, tagFilter = NULL, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL, executionFilter = NULL) {
  op <- new_operation(
    name = "ListOpenWorkflowExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$list_open_workflow_executions_input(domain = domain, startTimeFilter = startTimeFilter, typeFilter = typeFilter, tagFilter = tagFilter, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder, executionFilter = executionFilter)
  output <- .swf$list_open_workflow_executions_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_open_workflow_executions <- swf_list_open_workflow_executions

#' Returns information about workflow types in the specified domain
#'
#' Returns information about workflow types in the specified domain. The
#' results may be split into multiple pages that can be retrieved by making
#' the call repeatedly.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_list_workflow_types(domain, name, registrationStatus, nextPageToken,
#'   maximumPageSize, reverseOrder)
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow types have been registered.
#' @param name If specified, lists the workflow type with this name.
#' @param registrationStatus &#91;required&#93; Specifies the registration status of the workflow types to list.
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the results in reverse order. By default the
#' results are returned in ascending alphabetical order of the `name` of
#' the workflow types.
#'
#' @section Request syntax:
#' ```
#' svc$list_workflow_types(
#'   domain = "string",
#'   name = "string",
#'   registrationStatus = "REGISTERED"|"DEPRECATED",
#'   nextPageToken = "string",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_list_workflow_types
swf_list_workflow_types <- function(domain, name = NULL, registrationStatus, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "ListWorkflowTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$list_workflow_types_input(domain = domain, name = name, registrationStatus = registrationStatus, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$list_workflow_types_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$list_workflow_types <- swf_list_workflow_types

#' Used by workers to get an ActivityTask from the specified activity
#' taskList
#'
#' Used by workers to get an ActivityTask from the specified activity
#' `taskList`. This initiates a long poll, where the service holds the HTTP
#' connection open and responds as soon as a task becomes available. The
#' maximum time the service holds on to the request before responding is 60
#' seconds. If no task is available within 60 seconds, the poll returns an
#' empty result. An empty result, in this context, means that an
#' ActivityTask is returned, but that the value of taskToken is an empty
#' string. If a task is returned, the worker should use its type to
#' identify and process it correctly.
#' 
#' Workers should set their client side socket timeout to at least 70
#' seconds (10 seconds higher than the maximum time service may hold the
#' poll request).
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the `taskList.name` parameter by using a `Condition`
#'     element with the `swf:taskList.name` key to allow the action to
#'     access only certain task lists.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_poll_for_activity_task(domain, taskList, identity)
#'
#' @param domain &#91;required&#93; The name of the domain that contains the task lists being polled.
#' @param taskList &#91;required&#93; Specifies the task list to poll for activity tasks.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param identity Identity of the worker making the request, recorded in the
#' `ActivityTaskStarted` event in the workflow history. This enables
#' diagnostic tracing when problems arise. The form of this identity is
#' user defined.
#'
#' @section Request syntax:
#' ```
#' svc$poll_for_activity_task(
#'   domain = "string",
#'   taskList = list(
#'     name = "string"
#'   ),
#'   identity = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_poll_for_activity_task
swf_poll_for_activity_task <- function(domain, taskList, identity = NULL) {
  op <- new_operation(
    name = "PollForActivityTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$poll_for_activity_task_input(domain = domain, taskList = taskList, identity = identity)
  output <- .swf$poll_for_activity_task_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$poll_for_activity_task <- swf_poll_for_activity_task

#' Used by deciders to get a DecisionTask from the specified decision
#' taskList
#'
#' Used by deciders to get a DecisionTask from the specified decision
#' `taskList`. A decision task may be returned for any open workflow
#' execution that is using the specified task list. The task includes a
#' paginated view of the history of the workflow execution. The decider
#' should use the workflow type and the history to determine how to
#' properly handle the task.
#' 
#' This action initiates a long poll, where the service holds the HTTP
#' connection open and responds as soon a task becomes available. If no
#' decision task is available in the specified task list before the timeout
#' of 60 seconds expires, an empty result is returned. An empty result, in
#' this context, means that a DecisionTask is returned, but that the value
#' of taskToken is an empty string.
#' 
#' Deciders should set their client side socket timeout to at least 70
#' seconds (10 seconds higher than the timeout).
#' 
#' Because the number of workflow history events for a single workflow
#' execution might be very large, the result returned might be split up
#' across a number of pages. To retrieve subsequent pages, make additional
#' calls to `PollForDecisionTask` using the `nextPageToken` returned by the
#' initial call. Note that you do *not* call `GetWorkflowExecutionHistory`
#' with this `nextPageToken`. Instead, call `PollForDecisionTask` again.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the `taskList.name` parameter by using a `Condition`
#'     element with the `swf:taskList.name` key to allow the action to
#'     access only certain task lists.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_poll_for_decision_task(domain, taskList, identity, nextPageToken,
#'   maximumPageSize, reverseOrder)
#'
#' @param domain &#91;required&#93; The name of the domain containing the task lists to poll.
#' @param taskList &#91;required&#93; Specifies the task list to poll for decision tasks.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param identity Identity of the decider making the request, which is recorded in the
#' DecisionTaskStarted event in the workflow history. This enables
#' diagnostic tracing when problems arise. The form of this identity is
#' user defined.
#' @param nextPageToken If a `NextPageToken` was returned by a previous call, there are more
#' results available. To retrieve the next page of results, make the call
#' again using the returned token in `nextPageToken`. Keep all other
#' arguments unchanged.
#' 
#' The configured `maximumPageSize` determines how many results can be
#' returned in a single call.
#' 
#' The `nextPageToken` returned by this action cannot be used with
#' GetWorkflowExecutionHistory to get the next page. You must call
#' PollForDecisionTask again (with the `nextPageToken`) to retrieve the
#' next page of history records. Calling PollForDecisionTask with a
#' `nextPageToken` doesn\'t return a new decision task.
#' @param maximumPageSize The maximum number of results that are returned per call.
#' `nextPageToken` can be used to obtain futher pages of results. The
#' default is 1000, which is the maximum allowed page size. You can,
#' however, specify a page size *smaller* than the maximum.
#' 
#' This is an upper limit only; the actual number of results returned per
#' call may be fewer than the specified maximum.
#' @param reverseOrder When set to `true`, returns the events in reverse order. By default the
#' results are returned in ascending order of the `eventTimestamp` of the
#' events.
#'
#' @section Request syntax:
#' ```
#' svc$poll_for_decision_task(
#'   domain = "string",
#'   taskList = list(
#'     name = "string"
#'   ),
#'   identity = "string",
#'   nextPageToken = "string",
#'   maximumPageSize = 123,
#'   reverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_poll_for_decision_task
swf_poll_for_decision_task <- function(domain, taskList, identity = NULL, nextPageToken = NULL, maximumPageSize = NULL, reverseOrder = NULL) {
  op <- new_operation(
    name = "PollForDecisionTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$poll_for_decision_task_input(domain = domain, taskList = taskList, identity = identity, nextPageToken = nextPageToken, maximumPageSize = maximumPageSize, reverseOrder = reverseOrder)
  output <- .swf$poll_for_decision_task_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$poll_for_decision_task <- swf_poll_for_decision_task

#' Used by activity workers to report to the service that the ActivityTask
#' represented by the specified taskToken is still making progress
#'
#' Used by activity workers to report to the service that the ActivityTask
#' represented by the specified `taskToken` is still making progress. The
#' worker can also specify details of the progress, for example percent
#' complete, using the `details` parameter. This action can also be used by
#' the worker as a mechanism to check if cancellation is being requested
#' for the activity task. If a cancellation is being attempted for the
#' specified task, then the boolean `cancelRequested` flag returned by the
#' service is set to `true`.
#' 
#' This action resets the `taskHeartbeatTimeout` clock. The
#' `taskHeartbeatTimeout` is specified in RegisterActivityType.
#' 
#' This action doesn\'t in itself create an event in the workflow execution
#' history. However, if the task times out, the workflow execution history
#' contains a `ActivityTaskTimedOut` event that contains the information
#' from the last heartbeat generated by the activity worker.
#' 
#' The `taskStartToCloseTimeout` of an activity type is the maximum
#' duration of an activity task, regardless of the number of
#' RecordActivityTaskHeartbeat requests received. The
#' `taskStartToCloseTimeout` is also specified in RegisterActivityType.
#' 
#' This operation is only useful for long-lived activities to report
#' liveliness of the task and to determine if a cancellation is being
#' attempted.
#' 
#' If the `cancelRequested` flag returns `true`, a cancellation is being
#' attempted. If the worker can cancel the activity, it should respond with
#' RespondActivityTaskCanceled. Otherwise, it should ignore the
#' cancellation request.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_record_activity_task_heartbeat(taskToken, details)
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param details If specified, contains details about the progress of the task.
#'
#' @section Request syntax:
#' ```
#' svc$record_activity_task_heartbeat(
#'   taskToken = "string",
#'   details = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_record_activity_task_heartbeat
swf_record_activity_task_heartbeat <- function(taskToken, details = NULL) {
  op <- new_operation(
    name = "RecordActivityTaskHeartbeat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$record_activity_task_heartbeat_input(taskToken = taskToken, details = details)
  output <- .swf$record_activity_task_heartbeat_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$record_activity_task_heartbeat <- swf_record_activity_task_heartbeat

#' Registers a new _activity type_ along with its configuration settings in
#' the specified domain
#'
#' Registers a new *activity type* along with its configuration settings in
#' the specified domain.
#' 
#' A `TypeAlreadyExists` fault is returned if the type already exists in
#' the domain. You cannot change any configuration settings of the type
#' after its registration, and it must be registered as a new version.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `defaultTaskList.name`: String constraint. The key is
#'         `swf:defaultTaskList.name`.
#' 
#'     -   `name`: String constraint. The key is `swf:name`.
#' 
#'     -   `version`: String constraint. The key is `swf:version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_register_activity_type(domain, name, version, description,
#'   defaultTaskStartToCloseTimeout, defaultTaskHeartbeatTimeout,
#'   defaultTaskList, defaultTaskPriority, defaultTaskScheduleToStartTimeout,
#'   defaultTaskScheduleToCloseTimeout)
#'
#' @param domain &#91;required&#93; The name of the domain in which this activity is to be registered.
#' @param name &#91;required&#93; The name of the activity type within the domain.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param version &#91;required&#93; The version of the activity type.
#' 
#' The activity type consists of the name and version, the combination of
#' which must be unique within the domain.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param description A textual description of the activity type.
#' @param defaultTaskStartToCloseTimeout If set, specifies the default maximum duration that a worker can take to
#' process tasks of this activity type. This default can be overridden when
#' scheduling an activity task using the `ScheduleActivityTask` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultTaskHeartbeatTimeout If set, specifies the default maximum time before which a worker
#' processing a task of this type must report progress by calling
#' RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity
#' task is automatically timed out. This default can be overridden when
#' scheduling an activity task using the `ScheduleActivityTask` Decision.
#' If the activity worker subsequently attempts to record a heartbeat or
#' returns a result, the activity worker receives an `UnknownResource`
#' fault. In this case, Amazon SWF no longer considers the activity task to
#' be valid; the activity worker should clean up the activity task.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultTaskList If set, specifies the default task list to use for scheduling tasks of
#' this activity type. This default task list is used if a task list isn\'t
#' provided when a task is scheduled through the `ScheduleActivityTask`
#' Decision.
#' @param defaultTaskPriority The default task priority to assign to the activity type. If not
#' assigned, then `0` is used. Valid values are integers that range from
#' Java\'s `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE`
#' (2147483647). Higher numbers indicate higher priority.
#' 
#' For more information about setting task priority, see [Setting Task
#' Priority](http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
#' in the *in the *Amazon SWF Developer Guide*.*.
#' @param defaultTaskScheduleToStartTimeout If set, specifies the default maximum duration that a task of this
#' activity type can wait before being assigned to a worker. This default
#' can be overridden when scheduling an activity task using the
#' `ScheduleActivityTask` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultTaskScheduleToCloseTimeout If set, specifies the default maximum duration for a task of this
#' activity type. This default can be overridden when scheduling an
#' activity task using the `ScheduleActivityTask` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#'
#' @section Request syntax:
#' ```
#' svc$register_activity_type(
#'   domain = "string",
#'   name = "string",
#'   version = "string",
#'   description = "string",
#'   defaultTaskStartToCloseTimeout = "string",
#'   defaultTaskHeartbeatTimeout = "string",
#'   defaultTaskList = list(
#'     name = "string"
#'   ),
#'   defaultTaskPriority = "string",
#'   defaultTaskScheduleToStartTimeout = "string",
#'   defaultTaskScheduleToCloseTimeout = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_register_activity_type
swf_register_activity_type <- function(domain, name, version, description = NULL, defaultTaskStartToCloseTimeout = NULL, defaultTaskHeartbeatTimeout = NULL, defaultTaskList = NULL, defaultTaskPriority = NULL, defaultTaskScheduleToStartTimeout = NULL, defaultTaskScheduleToCloseTimeout = NULL) {
  op <- new_operation(
    name = "RegisterActivityType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$register_activity_type_input(domain = domain, name = name, version = version, description = description, defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout, defaultTaskHeartbeatTimeout = defaultTaskHeartbeatTimeout, defaultTaskList = defaultTaskList, defaultTaskPriority = defaultTaskPriority, defaultTaskScheduleToStartTimeout = defaultTaskScheduleToStartTimeout, defaultTaskScheduleToCloseTimeout = defaultTaskScheduleToCloseTimeout)
  output <- .swf$register_activity_type_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$register_activity_type <- swf_register_activity_type

#' Registers a new domain
#'
#' Registers a new domain.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   You cannot use an IAM policy to control domain access for this
#'     action. The name of the domain being registered is available as the
#'     resource of this action.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_register_domain(name, description,
#'   workflowExecutionRetentionPeriodInDays)
#'
#' @param name &#91;required&#93; Name of the domain to register. The name must be unique in the region
#' that the domain is registered in.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param description A text description of the domain.
#' @param workflowExecutionRetentionPeriodInDays &#91;required&#93; The duration (in days) that records and histories of workflow executions
#' on the domain should be kept by the service. After the retention period,
#' the workflow execution isn\'t available in the results of visibility
#' calls.
#' 
#' If you pass the value `NONE` or `0` (zero), then the workflow execution
#' history isn\'t retained. As soon as the workflow execution completes,
#' the execution record and its history are deleted.
#' 
#' The maximum workflow execution retention period is 90 days. For more
#' information about Amazon SWF service limits, see: [Amazon SWF Service
#' Limits](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$register_domain(
#'   name = "string",
#'   description = "string",
#'   workflowExecutionRetentionPeriodInDays = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_register_domain
swf_register_domain <- function(name, description = NULL, workflowExecutionRetentionPeriodInDays) {
  op <- new_operation(
    name = "RegisterDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$register_domain_input(name = name, description = description, workflowExecutionRetentionPeriodInDays = workflowExecutionRetentionPeriodInDays)
  output <- .swf$register_domain_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$register_domain <- swf_register_domain

#' Registers a new _workflow type_ and its configuration settings in the
#' specified domain
#'
#' Registers a new *workflow type* and its configuration settings in the
#' specified domain.
#' 
#' The retention period for the workflow history is set by the
#' RegisterDomain action.
#' 
#' If the type already exists, then a `TypeAlreadyExists` fault is
#' returned. You cannot change the configuration settings of a workflow
#' type once it is registered and it must be registered as a new version.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `defaultTaskList.name`: String constraint. The key is
#'         `swf:defaultTaskList.name`.
#' 
#'     -   `name`: String constraint. The key is `swf:name`.
#' 
#'     -   `version`: String constraint. The key is `swf:version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_register_workflow_type(domain, name, version, description,
#'   defaultTaskStartToCloseTimeout, defaultExecutionStartToCloseTimeout,
#'   defaultTaskList, defaultTaskPriority, defaultChildPolicy,
#'   defaultLambdaRole)
#'
#' @param domain &#91;required&#93; The name of the domain in which to register the workflow type.
#' @param name &#91;required&#93; The name of the workflow type.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param version &#91;required&#93; The version of the workflow type.
#' 
#' The workflow type consists of the name and version, the combination of
#' which must be unique within the domain. To get a list of all currently
#' registered workflow types, use the ListWorkflowTypes action.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param description Textual description of the workflow type.
#' @param defaultTaskStartToCloseTimeout If set, specifies the default maximum duration of decision tasks for
#' this workflow type. This default can be overridden when starting a
#' workflow execution using the StartWorkflowExecution action or the
#' `StartChildWorkflowExecution` Decision.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' @param defaultExecutionStartToCloseTimeout If set, specifies the default maximum duration for executions of this
#' workflow type. You can override this default when starting an execution
#' through the StartWorkflowExecution Action or
#' `StartChildWorkflowExecution` Decision.
#' 
#' The duration is specified in seconds; an integer greater than or equal
#' to 0. Unlike some of the other timeout parameters in Amazon SWF, you
#' cannot specify a value of \"NONE\" for
#' `defaultExecutionStartToCloseTimeout`; there is a one-year max limit on
#' the time that a workflow execution can run. Exceeding this limit always
#' causes the workflow execution to time out.
#' @param defaultTaskList If set, specifies the default task list to use for scheduling decision
#' tasks for executions of this workflow type. This default is used only if
#' a task list isn\'t provided when starting the execution through the
#' StartWorkflowExecution Action or `StartChildWorkflowExecution` Decision.
#' @param defaultTaskPriority The default task priority to assign to the workflow type. If not
#' assigned, then `0` is used. Valid values are integers that range from
#' Java\'s `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE`
#' (2147483647). Higher numbers indicate higher priority.
#' 
#' For more information about setting task priority, see [Setting Task
#' Priority](http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
#' in the *Amazon SWF Developer Guide*.
#' @param defaultChildPolicy If set, specifies the default policy to use for the child workflow
#' executions when a workflow execution of this type is terminated, by
#' calling the TerminateWorkflowExecution action explicitly or due to an
#' expired timeout. This default can be overridden when starting a workflow
#' execution using the StartWorkflowExecution action or the
#' `StartChildWorkflowExecution` Decision.
#' 
#' The supported child policies are:
#' 
#' -   `TERMINATE` -- The child executions are terminated.
#' 
#' -   `REQUEST_CANCEL` -- A request to cancel is attempted for each child
#'     execution by recording a `WorkflowExecutionCancelRequested` event in
#'     its history. It is up to the decider to take appropriate actions
#'     when it receives an execution history with this event.
#' 
#' -   `ABANDON` -- No action is taken. The child executions continue to
#'     run.
#' @param defaultLambdaRole The default IAM role attached to this workflow type.
#' 
#' Executions of this workflow type need IAM roles to invoke Lambda
#' functions. If you don\'t specify an IAM role when you start this
#' workflow type, the default Lambda role is attached to the execution. For
#' more information, see
#' <http://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html>
#' in the *Amazon SWF Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$register_workflow_type(
#'   domain = "string",
#'   name = "string",
#'   version = "string",
#'   description = "string",
#'   defaultTaskStartToCloseTimeout = "string",
#'   defaultExecutionStartToCloseTimeout = "string",
#'   defaultTaskList = list(
#'     name = "string"
#'   ),
#'   defaultTaskPriority = "string",
#'   defaultChildPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
#'   defaultLambdaRole = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_register_workflow_type
swf_register_workflow_type <- function(domain, name, version, description = NULL, defaultTaskStartToCloseTimeout = NULL, defaultExecutionStartToCloseTimeout = NULL, defaultTaskList = NULL, defaultTaskPriority = NULL, defaultChildPolicy = NULL, defaultLambdaRole = NULL) {
  op <- new_operation(
    name = "RegisterWorkflowType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$register_workflow_type_input(domain = domain, name = name, version = version, description = description, defaultTaskStartToCloseTimeout = defaultTaskStartToCloseTimeout, defaultExecutionStartToCloseTimeout = defaultExecutionStartToCloseTimeout, defaultTaskList = defaultTaskList, defaultTaskPriority = defaultTaskPriority, defaultChildPolicy = defaultChildPolicy, defaultLambdaRole = defaultLambdaRole)
  output <- .swf$register_workflow_type_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$register_workflow_type <- swf_register_workflow_type

#' Records a WorkflowExecutionCancelRequested event in the currently
#' running workflow execution identified by the given domain, workflowId,
#' and runId
#'
#' Records a `WorkflowExecutionCancelRequested` event in the currently
#' running workflow execution identified by the given domain, workflowId,
#' and runId. This logically requests the cancellation of the workflow
#' execution as a whole. It is up to the decider to take appropriate
#' actions when it receives an execution history with this event.
#' 
#' If the runId isn\'t specified, the `WorkflowExecutionCancelRequested`
#' event is recorded in the history of the current open workflow execution
#' with the specified workflowId in the domain.
#' 
#' Because this action allows the workflow to properly clean up and
#' gracefully close, it should be used instead of
#' TerminateWorkflowExecution when possible.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_request_cancel_workflow_execution(domain, workflowId, runId)
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution to cancel.
#' @param workflowId &#91;required&#93; The workflowId of the workflow execution to cancel.
#' @param runId The runId of the workflow execution to cancel.
#'
#' @section Request syntax:
#' ```
#' svc$request_cancel_workflow_execution(
#'   domain = "string",
#'   workflowId = "string",
#'   runId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_request_cancel_workflow_execution
swf_request_cancel_workflow_execution <- function(domain, workflowId, runId = NULL) {
  op <- new_operation(
    name = "RequestCancelWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$request_cancel_workflow_execution_input(domain = domain, workflowId = workflowId, runId = runId)
  output <- .swf$request_cancel_workflow_execution_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$request_cancel_workflow_execution <- swf_request_cancel_workflow_execution

#' Used by workers to tell the service that the ActivityTask identified by
#' the taskToken was successfully canceled
#'
#' Used by workers to tell the service that the ActivityTask identified by
#' the `taskToken` was successfully canceled. Additional `details` can be
#' provided using the `details` argument.
#' 
#' These `details` (if provided) appear in the `ActivityTaskCanceled` event
#' added to the workflow history.
#' 
#' Only use this operation if the `canceled` flag of a
#' RecordActivityTaskHeartbeat request returns `true` and if the activity
#' can be safely undone or abandoned.
#' 
#' A task is considered open from the time that it is scheduled until it is
#' closed. Therefore a task is reported as open while a worker is
#' processing it. A task is closed after it has been specified in a call to
#' RespondActivityTaskCompleted, RespondActivityTaskCanceled,
#' RespondActivityTaskFailed, or the task has [timed
#' out](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_respond_activity_task_canceled(taskToken, details)
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param details Information about the cancellation.
#'
#' @section Request syntax:
#' ```
#' svc$respond_activity_task_canceled(
#'   taskToken = "string",
#'   details = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_respond_activity_task_canceled
swf_respond_activity_task_canceled <- function(taskToken, details = NULL) {
  op <- new_operation(
    name = "RespondActivityTaskCanceled",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$respond_activity_task_canceled_input(taskToken = taskToken, details = details)
  output <- .swf$respond_activity_task_canceled_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_activity_task_canceled <- swf_respond_activity_task_canceled

#' Used by workers to tell the service that the ActivityTask identified by
#' the taskToken completed successfully with a result (if provided)
#'
#' Used by workers to tell the service that the ActivityTask identified by
#' the `taskToken` completed successfully with a `result` (if provided).
#' The `result` appears in the `ActivityTaskCompleted` event in the
#' workflow history.
#' 
#' If the requested task doesn\'t complete successfully, use
#' RespondActivityTaskFailed instead. If the worker finds that the task is
#' canceled through the `canceled` flag returned by
#' RecordActivityTaskHeartbeat, it should cancel the task, clean up and
#' then call RespondActivityTaskCanceled.
#' 
#' A task is considered open from the time that it is scheduled until it is
#' closed. Therefore a task is reported as open while a worker is
#' processing it. A task is closed after it has been specified in a call to
#' RespondActivityTaskCompleted, RespondActivityTaskCanceled,
#' RespondActivityTaskFailed, or the task has [timed
#' out](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_respond_activity_task_completed(taskToken, result)
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param result The result of the activity task. It is a free form string that is
#' implementation specific.
#'
#' @section Request syntax:
#' ```
#' svc$respond_activity_task_completed(
#'   taskToken = "string",
#'   result = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_respond_activity_task_completed
swf_respond_activity_task_completed <- function(taskToken, result = NULL) {
  op <- new_operation(
    name = "RespondActivityTaskCompleted",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$respond_activity_task_completed_input(taskToken = taskToken, result = result)
  output <- .swf$respond_activity_task_completed_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_activity_task_completed <- swf_respond_activity_task_completed

#' Used by workers to tell the service that the ActivityTask identified by
#' the taskToken has failed with reason (if specified)
#'
#' Used by workers to tell the service that the ActivityTask identified by
#' the `taskToken` has failed with `reason` (if specified). The `reason`
#' and `details` appear in the `ActivityTaskFailed` event added to the
#' workflow history.
#' 
#' A task is considered open from the time that it is scheduled until it is
#' closed. Therefore a task is reported as open while a worker is
#' processing it. A task is closed after it has been specified in a call to
#' RespondActivityTaskCompleted, RespondActivityTaskCanceled,
#' RespondActivityTaskFailed, or the task has [timed
#' out](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_respond_activity_task_failed(taskToken, reason, details)
#'
#' @param taskToken &#91;required&#93; The `taskToken` of the ActivityTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param reason Description of the error that may assist in diagnostics.
#' @param details Detailed information about the failure.
#'
#' @section Request syntax:
#' ```
#' svc$respond_activity_task_failed(
#'   taskToken = "string",
#'   reason = "string",
#'   details = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_respond_activity_task_failed
swf_respond_activity_task_failed <- function(taskToken, reason = NULL, details = NULL) {
  op <- new_operation(
    name = "RespondActivityTaskFailed",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$respond_activity_task_failed_input(taskToken = taskToken, reason = reason, details = details)
  output <- .swf$respond_activity_task_failed_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_activity_task_failed <- swf_respond_activity_task_failed

#' Used by deciders to tell the service that the DecisionTask identified by
#' the taskToken has successfully completed
#'
#' Used by deciders to tell the service that the DecisionTask identified by
#' the `taskToken` has successfully completed. The `decisions` argument
#' specifies the list of decisions made while processing the task.
#' 
#' A `DecisionTaskCompleted` event is added to the workflow history. The
#' `executionContext` specified is attached to the event in the workflow
#' execution history.
#' 
#' **Access Control**
#' 
#' If an IAM policy grants permission to use
#' `RespondDecisionTaskCompleted`, it can express permissions for the list
#' of decisions in the `decisions` parameter. Each of the decisions has one
#' or more parameters, much like a regular API call. To allow for policies
#' to be as readable as possible, you can express permissions on decisions
#' as if they were actual API calls, including applying conditions to some
#' parameters. For more information, see [Using IAM to Manage Access to
#' Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_respond_decision_task_completed(taskToken, decisions,
#'   executionContext)
#'
#' @param taskToken &#91;required&#93; The `taskToken` from the DecisionTask.
#' 
#' `taskToken` is generated by the service and should be treated as an
#' opaque value. If the task is passed to another process, its `taskToken`
#' must also be passed. This enables it to provide its progress and respond
#' with results.
#' @param decisions The list of decisions (possibly empty) made by the decider while
#' processing this decision task. See the docs for the Decision structure
#' for details.
#' @param executionContext User defined context to add to workflow execution.
#'
#' @section Request syntax:
#' ```
#' svc$respond_decision_task_completed(
#'   taskToken = "string",
#'   decisions = list(
#'     list(
#'       decisionType = "ScheduleActivityTask"|"RequestCancelActivityTask"|"CompleteWorkflowExecution"|"FailWorkflowExecution"|"CancelWorkflowExecution"|"ContinueAsNewWorkflowExecution"|"RecordMarker"|"StartTimer"|"CancelTimer"|"SignalExternalWorkflowExecution"|"RequestCancelExternalWorkflowExecution"|"StartChildWorkflowExecution"|"ScheduleLambdaFunction",
#'       scheduleActivityTaskDecisionAttributes = list(
#'         activityType = list(
#'           name = "string",
#'           version = "string"
#'         ),
#'         activityId = "string",
#'         control = "string",
#'         input = "string",
#'         scheduleToCloseTimeout = "string",
#'         taskList = list(
#'           name = "string"
#'         ),
#'         taskPriority = "string",
#'         scheduleToStartTimeout = "string",
#'         startToCloseTimeout = "string",
#'         heartbeatTimeout = "string"
#'       ),
#'       requestCancelActivityTaskDecisionAttributes = list(
#'         activityId = "string"
#'       ),
#'       completeWorkflowExecutionDecisionAttributes = list(
#'         result = "string"
#'       ),
#'       failWorkflowExecutionDecisionAttributes = list(
#'         reason = "string",
#'         details = "string"
#'       ),
#'       cancelWorkflowExecutionDecisionAttributes = list(
#'         details = "string"
#'       ),
#'       continueAsNewWorkflowExecutionDecisionAttributes = list(
#'         input = "string",
#'         executionStartToCloseTimeout = "string",
#'         taskList = list(
#'           name = "string"
#'         ),
#'         taskPriority = "string",
#'         taskStartToCloseTimeout = "string",
#'         childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
#'         tagList = list(
#'           "string"
#'         ),
#'         workflowTypeVersion = "string",
#'         lambdaRole = "string"
#'       ),
#'       recordMarkerDecisionAttributes = list(
#'         markerName = "string",
#'         details = "string"
#'       ),
#'       startTimerDecisionAttributes = list(
#'         timerId = "string",
#'         control = "string",
#'         startToFireTimeout = "string"
#'       ),
#'       cancelTimerDecisionAttributes = list(
#'         timerId = "string"
#'       ),
#'       signalExternalWorkflowExecutionDecisionAttributes = list(
#'         workflowId = "string",
#'         runId = "string",
#'         signalName = "string",
#'         input = "string",
#'         control = "string"
#'       ),
#'       requestCancelExternalWorkflowExecutionDecisionAttributes = list(
#'         workflowId = "string",
#'         runId = "string",
#'         control = "string"
#'       ),
#'       startChildWorkflowExecutionDecisionAttributes = list(
#'         workflowType = list(
#'           name = "string",
#'           version = "string"
#'         ),
#'         workflowId = "string",
#'         control = "string",
#'         input = "string",
#'         executionStartToCloseTimeout = "string",
#'         taskList = list(
#'           name = "string"
#'         ),
#'         taskPriority = "string",
#'         taskStartToCloseTimeout = "string",
#'         childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
#'         tagList = list(
#'           "string"
#'         ),
#'         lambdaRole = "string"
#'       ),
#'       scheduleLambdaFunctionDecisionAttributes = list(
#'         id = "string",
#'         name = "string",
#'         control = "string",
#'         input = "string",
#'         startToCloseTimeout = "string"
#'       )
#'     )
#'   ),
#'   executionContext = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_respond_decision_task_completed
swf_respond_decision_task_completed <- function(taskToken, decisions = NULL, executionContext = NULL) {
  op <- new_operation(
    name = "RespondDecisionTaskCompleted",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$respond_decision_task_completed_input(taskToken = taskToken, decisions = decisions, executionContext = executionContext)
  output <- .swf$respond_decision_task_completed_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$respond_decision_task_completed <- swf_respond_decision_task_completed

#' Records a WorkflowExecutionSignaled event in the workflow execution
#' history and creates a decision task for the workflow execution
#' identified by the given domain, workflowId and runId
#'
#' Records a `WorkflowExecutionSignaled` event in the workflow execution
#' history and creates a decision task for the workflow execution
#' identified by the given domain, workflowId and runId. The event is
#' recorded with the specified user defined signalName and input (if
#' provided).
#' 
#' If a runId isn\'t specified, then the `WorkflowExecutionSignaled` event
#' is recorded in the history of the current open workflow with the
#' matching workflowId in the domain.
#' 
#' If the specified workflow execution isn\'t open, this method fails with
#' `UnknownResource`.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_signal_workflow_execution(domain, workflowId, runId, signalName,
#'   input)
#'
#' @param domain &#91;required&#93; The name of the domain containing the workflow execution to signal.
#' @param workflowId &#91;required&#93; The workflowId of the workflow execution to signal.
#' @param runId The runId of the workflow execution to signal.
#' @param signalName &#91;required&#93; The name of the signal. This name must be meaningful to the target
#' workflow.
#' @param input Data to attach to the `WorkflowExecutionSignaled` event in the target
#' workflow execution\'s history.
#'
#' @section Request syntax:
#' ```
#' svc$signal_workflow_execution(
#'   domain = "string",
#'   workflowId = "string",
#'   runId = "string",
#'   signalName = "string",
#'   input = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_signal_workflow_execution
swf_signal_workflow_execution <- function(domain, workflowId, runId = NULL, signalName, input = NULL) {
  op <- new_operation(
    name = "SignalWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$signal_workflow_execution_input(domain = domain, workflowId = workflowId, runId = runId, signalName = signalName, input = input)
  output <- .swf$signal_workflow_execution_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$signal_workflow_execution <- swf_signal_workflow_execution

#' Starts an execution of the workflow type in the specified domain using
#' the provided workflowId and input data
#'
#' Starts an execution of the workflow type in the specified domain using
#' the provided `workflowId` and input data.
#' 
#' This action returns the newly started workflow execution.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   Constrain the following parameters by using a `Condition` element
#'     with the appropriate keys.
#' 
#'     -   `tagList.member.0`: The key is `swf:tagList.member.0`.
#' 
#'     -   `tagList.member.1`: The key is `swf:tagList.member.1`.
#' 
#'     -   `tagList.member.2`: The key is `swf:tagList.member.2`.
#' 
#'     -   `tagList.member.3`: The key is `swf:tagList.member.3`.
#' 
#'     -   `tagList.member.4`: The key is `swf:tagList.member.4`.
#' 
#'     -   `taskList`: String constraint. The key is `swf:taskList.name`.
#' 
#'     -   `workflowType.name`: String constraint. The key is
#'         `swf:workflowType.name`.
#' 
#'     -   `workflowType.version`: String constraint. The key is
#'         `swf:workflowType.version`.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_start_workflow_execution(domain, workflowId, workflowType, taskList,
#'   taskPriority, input, executionStartToCloseTimeout, tagList,
#'   taskStartToCloseTimeout, childPolicy, lambdaRole)
#'
#' @param domain &#91;required&#93; The name of the domain in which the workflow execution is created.
#' @param workflowId &#91;required&#93; The user defined identifier associated with the workflow execution. You
#' can use this to associate a custom identifier with the workflow
#' execution. You may specify the same identifier if a workflow execution
#' is logically a *restart* of a previous execution. You cannot have two
#' open workflow executions with the same `workflowId` at the same time.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param workflowType &#91;required&#93; The type of the workflow to start.
#' @param taskList The task list to use for the decision tasks generated for this workflow
#' execution. This overrides the `defaultTaskList` specified when
#' registering the workflow type.
#' 
#' A task list for this workflow execution must be specified either as a
#' default for the workflow type or through this parameter. If neither this
#' parameter is set nor a default task list was specified at registration
#' time then a fault is returned.
#' 
#' The specified string must not start or end with whitespace. It must not
#' contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control
#' characters (``U+0000`-`U+001f`` \\| ``U+007f`-`U+009f``). Also, it must not
#' contain the literal string `arn`.
#' @param taskPriority The task priority to use for this workflow execution. This overrides any
#' default priority that was assigned when the workflow type was
#' registered. If not set, then the default task priority for the workflow
#' type is used. Valid values are integers that range from Java\'s
#' `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647).
#' Higher numbers indicate higher priority.
#' 
#' For more information about setting task priority, see [Setting Task
#' Priority](http://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
#' in the *Amazon SWF Developer Guide*.
#' @param input The input for the workflow execution. This is a free form string which
#' should be meaningful to the workflow you are starting. This `input` is
#' made available to the new workflow execution in the
#' `WorkflowExecutionStarted` history event.
#' @param executionStartToCloseTimeout The total duration for this workflow execution. This overrides the
#' defaultExecutionStartToCloseTimeout specified when registering the
#' workflow type.
#' 
#' The duration is specified in seconds; an integer greater than or equal
#' to `0`. Exceeding this limit causes the workflow execution to time out.
#' Unlike some of the other timeout parameters in Amazon SWF, you cannot
#' specify a value of \"NONE\" for this timeout; there is a one-year max
#' limit on the time that a workflow execution can run.
#' 
#' An execution start-to-close timeout must be specified either through
#' this parameter or as a default when the workflow type is registered. If
#' neither this parameter nor a default execution start-to-close timeout is
#' specified, a fault is returned.
#' @param tagList The list of tags to associate with the workflow execution. You can
#' specify a maximum of 5 tags. You can list workflow executions with a
#' specific tag by calling ListOpenWorkflowExecutions or
#' ListClosedWorkflowExecutions and specifying a TagFilter.
#' @param taskStartToCloseTimeout Specifies the maximum duration of decision tasks for this workflow
#' execution. This parameter overrides the `defaultTaskStartToCloseTimout`
#' specified when registering the workflow type using RegisterWorkflowType.
#' 
#' The duration is specified in seconds, an integer greater than or equal
#' to `0`. You can use `NONE` to specify unlimited duration.
#' 
#' A task start-to-close timeout for this workflow execution must be
#' specified either as a default for the workflow type or through this
#' parameter. If neither this parameter is set nor a default task
#' start-to-close timeout was specified at registration time then a fault
#' is returned.
#' @param childPolicy If set, specifies the policy to use for the child workflow executions of
#' this workflow execution if it is terminated, by calling the
#' TerminateWorkflowExecution action explicitly or due to an expired
#' timeout. This policy overrides the default child policy specified when
#' registering the workflow type using RegisterWorkflowType.
#' 
#' The supported child policies are:
#' 
#' -   `TERMINATE` -- The child executions are terminated.
#' 
#' -   `REQUEST_CANCEL` -- A request to cancel is attempted for each child
#'     execution by recording a `WorkflowExecutionCancelRequested` event in
#'     its history. It is up to the decider to take appropriate actions
#'     when it receives an execution history with this event.
#' 
#' -   `ABANDON` -- No action is taken. The child executions continue to
#'     run.
#' 
#' A child policy for this workflow execution must be specified either as a
#' default for the workflow type or through this parameter. If neither this
#' parameter is set nor a default child policy was specified at
#' registration time then a fault is returned.
#' @param lambdaRole The IAM role to attach to this workflow execution.
#' 
#' Executions of this workflow type need IAM roles to invoke Lambda
#' functions. If you don\'t attach an IAM role, any attempt to schedule a
#' Lambda task fails. This results in a `ScheduleLambdaFunctionFailed`
#' history event. For more information, see
#' <http://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html>
#' in the *Amazon SWF Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$start_workflow_execution(
#'   domain = "string",
#'   workflowId = "string",
#'   workflowType = list(
#'     name = "string",
#'     version = "string"
#'   ),
#'   taskList = list(
#'     name = "string"
#'   ),
#'   taskPriority = "string",
#'   input = "string",
#'   executionStartToCloseTimeout = "string",
#'   tagList = list(
#'     "string"
#'   ),
#'   taskStartToCloseTimeout = "string",
#'   childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
#'   lambdaRole = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_start_workflow_execution
swf_start_workflow_execution <- function(domain, workflowId, workflowType, taskList = NULL, taskPriority = NULL, input = NULL, executionStartToCloseTimeout = NULL, tagList = NULL, taskStartToCloseTimeout = NULL, childPolicy = NULL, lambdaRole = NULL) {
  op <- new_operation(
    name = "StartWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$start_workflow_execution_input(domain = domain, workflowId = workflowId, workflowType = workflowType, taskList = taskList, taskPriority = taskPriority, input = input, executionStartToCloseTimeout = executionStartToCloseTimeout, tagList = tagList, taskStartToCloseTimeout = taskStartToCloseTimeout, childPolicy = childPolicy, lambdaRole = lambdaRole)
  output <- .swf$start_workflow_execution_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$start_workflow_execution <- swf_start_workflow_execution

#' Records a WorkflowExecutionTerminated event and forces closure of the
#' workflow execution identified by the given domain, runId, and workflowId
#'
#' Records a `WorkflowExecutionTerminated` event and forces closure of the
#' workflow execution identified by the given domain, runId, and
#' workflowId. The child policy, registered with the workflow type or
#' specified when starting this execution, is applied to any open child
#' workflow executions of this workflow execution.
#' 
#' If the identified workflow execution was in progress, it is terminated
#' immediately.
#' 
#' If a runId isn\'t specified, then the `WorkflowExecutionTerminated`
#' event is recorded in the history of the current open workflow with the
#' matching workflowId in the domain.
#' 
#' You should consider using RequestCancelWorkflowExecution action instead
#' because it allows the workflow to gracefully close while
#' TerminateWorkflowExecution doesn\'t.
#' 
#' **Access Control**
#' 
#' You can use IAM policies to control this action\'s access to Amazon SWF
#' resources as follows:
#' 
#' -   Use a `Resource` element with the domain name to limit the action to
#'     only specified domains.
#' 
#' -   Use an `Action` element to allow or deny permission to call this
#'     action.
#' 
#' -   You cannot use an IAM policy to constrain this action\'s parameters.
#' 
#' If the caller doesn\'t have sufficient permissions to invoke the action,
#' or the parameter values fall outside the specified constraints, the
#' action fails. The associated event attribute\'s `cause` parameter is set
#' to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see
#' [Using IAM to Manage Access to Amazon SWF
#' Workflows](http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
#' in the *Amazon SWF Developer Guide*.
#'
#' @usage
#' swf_terminate_workflow_execution(domain, workflowId, runId, reason,
#'   details, childPolicy)
#'
#' @param domain &#91;required&#93; The domain of the workflow execution to terminate.
#' @param workflowId &#91;required&#93; The workflowId of the workflow execution to terminate.
#' @param runId The runId of the workflow execution to terminate.
#' @param reason A descriptive reason for terminating the workflow execution.
#' @param details Details for terminating the workflow execution.
#' @param childPolicy If set, specifies the policy to use for the child workflow executions of
#' the workflow execution being terminated. This policy overrides the child
#' policy specified for the workflow execution at registration time or when
#' starting the execution.
#' 
#' The supported child policies are:
#' 
#' -   `TERMINATE` -- The child executions are terminated.
#' 
#' -   `REQUEST_CANCEL` -- A request to cancel is attempted for each child
#'     execution by recording a `WorkflowExecutionCancelRequested` event in
#'     its history. It is up to the decider to take appropriate actions
#'     when it receives an execution history with this event.
#' 
#' -   `ABANDON` -- No action is taken. The child executions continue to
#'     run.
#' 
#' A child policy for this workflow execution must be specified either as a
#' default for the workflow type or through this parameter. If neither this
#' parameter is set nor a default child policy was specified at
#' registration time then a fault is returned.
#'
#' @section Request syntax:
#' ```
#' svc$terminate_workflow_execution(
#'   domain = "string",
#'   workflowId = "string",
#'   runId = "string",
#'   reason = "string",
#'   details = "string",
#'   childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname swf_terminate_workflow_execution
swf_terminate_workflow_execution <- function(domain, workflowId, runId = NULL, reason = NULL, details = NULL, childPolicy = NULL) {
  op <- new_operation(
    name = "TerminateWorkflowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .swf$terminate_workflow_execution_input(domain = domain, workflowId = workflowId, runId = runId, reason = reason, details = details, childPolicy = childPolicy)
  output <- .swf$terminate_workflow_execution_output()
  svc <- .swf$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.swf$operations$terminate_workflow_execution <- swf_terminate_workflow_execution
