% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_get_session_embed_url}
\alias{quicksight_get_session_embed_url}
\title{Generates a session URL and authorization code that you can use to embed
the Amazon Amazon QuickSight console in your web server code}
\usage{
quicksight_get_session_embed_url(
  AwsAccountId,
  EntryPoint = NULL,
  SessionLifetimeInMinutes = NULL,
  UserArn = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the Amazon Web Services account associated with your Amazon
QuickSight subscription.}

\item{EntryPoint}{The URL you use to access the embedded session. The entry point URL is
constrained to the following paths:
\itemize{
\item \verb{/start}
\item \verb{/start/analyses}
\item \verb{/start/dashboards}
\item \verb{/start/favorites}
\item \verb{/dashboards/DashboardId } - where \code{DashboardId} is the actual ID
key from the Amazon QuickSight console URL of the dashboard
\item \verb{/analyses/AnalysisId } - where \code{AnalysisId} is the actual ID key
from the Amazon QuickSight console URL of the analysis
}}

\item{SessionLifetimeInMinutes}{How many minutes the session is valid. The session lifetime must be
15-600 minutes.}

\item{UserArn}{The Amazon QuickSight user's Amazon Resource Name (ARN), for use with
\code{QUICKSIGHT} identity type. You can use this for any type of Amazon
QuickSight users in your account (readers, authors, or admins). They
need to be authenticated as one of the following:
\enumerate{
\item Active Directory (AD) users or group members
\item Invited nonfederated users
\item IAM users and IAM role-based sessions authenticated through
Federated Single Sign-On using SAML, OpenID Connect, or IAM
federation
}

Omit this parameter for users in the third group, IAM users and IAM
role-based sessions.}
}
\description{
Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use \code{\link[=quicksight_get_session_embed_url]{get_session_embed_url}} where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the \code{\link[=quicksight_update_user]{update_user}} API operation. Use \code{\link[=quicksight_register_user]{register_user}} API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the \emph{Amazon QuickSight User Guide}:

See \url{https://www.paws-r-sdk.com/docs/quicksight_get_session_embed_url/} for full documentation.
}
\keyword{internal}
