% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_list_channels}
\alias{ivs_list_channels}
\title{Gets summary information about all channels in your account, in the
Amazon Web Services region where the API request is processed}
\usage{
ivs_list_channels(
  filterByName = NULL,
  filterByPlaybackRestrictionPolicyArn = NULL,
  filterByRecordingConfigurationArn = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{filterByName}{Filters the channel list to match the specified name.}

\item{filterByPlaybackRestrictionPolicyArn}{Filters the channel list to match the specified policy.}

\item{filterByRecordingConfigurationArn}{Filters the channel list to match the specified recording-configuration
ARN.}

\item{maxResults}{Maximum number of channels to return. Default: 100.}

\item{nextToken}{The first channel to retrieve. This is used for pagination; see the
\code{nextToken} response field.}
}
\description{
Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).

See \url{https://www.paws-r-sdk.com/docs/ivs_list_channels/} for full documentation.
}
\keyword{internal}
