% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivsrealtime_operations.R
\name{ivsrealtime_list_participant_events}
\alias{ivsrealtime_list_participant_events}
\title{Lists events for a specified participant that occurred during a
specified stage session}
\usage{
ivsrealtime_list_participant_events(
  stageArn,
  sessionId,
  participantId,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{stageArn}{[required] Stage ARN.}

\item{sessionId}{[required] ID of a session within the stage.}

\item{participantId}{[required] Unique identifier for this participant. This is assigned by IVS and
returned by
\code{\link[=ivsrealtime_create_participant_token]{create_participant_token}}.}

\item{nextToken}{The first participant event to retrieve. This is used for pagination;
see the \code{nextToken} response field.}

\item{maxResults}{Maximum number of results to return. Default: 50.}
}
\description{
Lists events for a specified participant that occurred during a specified stage session.

See \url{https://www.paws-r-sdk.com/docs/ivsrealtime_list_participant_events/} for full documentation.
}
\keyword{internal}
