% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/healthlake_operations.R
\name{healthlake_create_fhir_datastore}
\alias{healthlake_create_fhir_datastore}
\title{Creates a data store that can ingest and export FHIR formatted data}
\usage{
healthlake_create_fhir_datastore(
  DatastoreName = NULL,
  DatastoreTypeVersion,
  SseConfiguration = NULL,
  PreloadDataConfig = NULL,
  ClientToken = NULL,
  Tags = NULL,
  IdentityProviderConfiguration = NULL
)
}
\arguments{
\item{DatastoreName}{The user generated name for the data store.}

\item{DatastoreTypeVersion}{[required] The FHIR version of the data store. The only supported version is R4.}

\item{SseConfiguration}{The server-side encryption key configuration for a customer provided
encryption key specified for creating a data store.}

\item{PreloadDataConfig}{Optional parameter to preload data upon creation of the data store.
Currently, the only supported preloaded data is synthetic data generated
from Synthea.}

\item{ClientToken}{Optional user provided token used for ensuring idempotency.}

\item{Tags}{Resource tags that are applied to a data store when it is created.}

\item{IdentityProviderConfiguration}{The configuration of the identity provider that you want to use for your
data store.}
}
\description{
Creates a data store that can ingest and export FHIR formatted data.

See \url{https://www.paws-r-sdk.com/docs/healthlake_create_fhir_datastore/} for full documentation.
}
\keyword{internal}
