% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_entity_owners}
\alias{datazone_list_entity_owners}
\title{Lists the entity (domain units) owners}
\usage{
datazone_list_entity_owners(
  domainIdentifier,
  entityIdentifier,
  entityType,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The ID of the domain where you want to list entity owners.}

\item{entityIdentifier}{[required] The ID of the entity that you want to list.}

\item{entityType}{[required] The type of the entity that you want to list.}

\item{maxResults}{The maximum number of entities to return in a single call to
\code{\link[=datazone_list_entity_owners]{list_entity_owners}}. When the number of
entities to be listed is greater than the value of \code{MaxResults}, the
response contains a \code{NextToken} value that you can use in a subsequent
call to \code{\link[=datazone_list_entity_owners]{list_entity_owners}} to list the
next set of entities.}

\item{nextToken}{When the number of entities is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of entities, the response
includes a pagination token named \code{NextToken}. You can specify this
\code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_entity_owners]{list_entity_owners}} to list the next set
of entities.}
}
\description{
Lists the entity (domain units) owners.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_entity_owners/} for full documentation.
}
\keyword{internal}
