# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include opensearchingestion_service.R
NULL

#' Creates an OpenSearch Ingestion pipeline
#'
#' @description
#' Creates an OpenSearch Ingestion pipeline. For more information, see [Creating Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_create_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_create_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the OpenSearch Ingestion pipeline to create. Pipeline names
#' are unique across the pipelines owned by an account within an Amazon Web
#' Services Region.
#' @param MinUnits &#91;required&#93; The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
#' @param MaxUnits &#91;required&#93; The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
#' @param PipelineConfigurationBody &#91;required&#93; The pipeline configuration in YAML format. The command accepts the
#' pipeline configuration as a string or within a .yaml file. If you
#' provide the configuration as a string, each new line must be escaped
#' with `\\n`.
#' @param LogPublishingOptions Key-value pairs to configure log publishing.
#' @param VpcOptions Container for the values required to configure VPC access for the
#' pipeline. If you don't specify these values, OpenSearch Ingestion
#' creates the pipeline with a public endpoint.
#' @param BufferOptions Key-value pairs to configure persistent buffering for the pipeline.
#' @param EncryptionAtRestOptions Key-value pairs to configure encryption for data that is written to a
#' persistent buffer.
#' @param Tags List of tags to add to the pipeline upon creation.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_create_pipeline
opensearchingestion_create_pipeline <- function(PipelineName, MinUnits, MaxUnits, PipelineConfigurationBody, LogPublishingOptions = NULL, VpcOptions = NULL, BufferOptions = NULL, EncryptionAtRestOptions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePipeline",
    http_method = "POST",
    http_path = "/2022-01-01/osis/createPipeline",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$create_pipeline_input(PipelineName = PipelineName, MinUnits = MinUnits, MaxUnits = MaxUnits, PipelineConfigurationBody = PipelineConfigurationBody, LogPublishingOptions = LogPublishingOptions, VpcOptions = VpcOptions, BufferOptions = BufferOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, Tags = Tags)
  output <- .opensearchingestion$create_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$create_pipeline <- opensearchingestion_create_pipeline

#' Deletes an OpenSearch Ingestion pipeline
#'
#' @description
#' Deletes an OpenSearch Ingestion pipeline. For more information, see [Deleting Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/delete-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_delete_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_delete_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to delete.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_delete_pipeline
opensearchingestion_delete_pipeline <- function(PipelineName) {
  op <- new_operation(
    name = "DeletePipeline",
    http_method = "DELETE",
    http_path = "/2022-01-01/osis/deletePipeline/{PipelineName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$delete_pipeline_input(PipelineName = PipelineName)
  output <- .opensearchingestion$delete_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$delete_pipeline <- opensearchingestion_delete_pipeline

#' Retrieves information about an OpenSearch Ingestion pipeline
#'
#' @description
#' Retrieves information about an OpenSearch Ingestion pipeline.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_get_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_get_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_get_pipeline
opensearchingestion_get_pipeline <- function(PipelineName) {
  op <- new_operation(
    name = "GetPipeline",
    http_method = "GET",
    http_path = "/2022-01-01/osis/getPipeline/{PipelineName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$get_pipeline_input(PipelineName = PipelineName)
  output <- .opensearchingestion$get_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$get_pipeline <- opensearchingestion_get_pipeline

#' Retrieves information about a specific blueprint for OpenSearch
#' Ingestion
#'
#' @description
#' Retrieves information about a specific blueprint for OpenSearch Ingestion. Blueprints are templates for the configuration needed for a [`create_pipeline`][opensearchingestion_create_pipeline] request. For more information, see [Using blueprints to create a pipeline](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_get_pipeline_blueprint/](https://www.paws-r-sdk.com/docs/opensearchingestion_get_pipeline_blueprint/) for full documentation.
#'
#' @param BlueprintName &#91;required&#93; The name of the blueprint to retrieve.
#' @param Format The format format of the blueprint to retrieve.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_get_pipeline_blueprint
opensearchingestion_get_pipeline_blueprint <- function(BlueprintName, Format = NULL) {
  op <- new_operation(
    name = "GetPipelineBlueprint",
    http_method = "GET",
    http_path = "/2022-01-01/osis/getPipelineBlueprint/{BlueprintName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$get_pipeline_blueprint_input(BlueprintName = BlueprintName, Format = Format)
  output <- .opensearchingestion$get_pipeline_blueprint_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$get_pipeline_blueprint <- opensearchingestion_get_pipeline_blueprint

#' Returns progress information for the current change happening on an
#' OpenSearch Ingestion pipeline
#'
#' @description
#' Returns progress information for the current change happening on an OpenSearch Ingestion pipeline. Currently, this operation only returns information when a pipeline is being created.
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_get_pipeline_change_progress/](https://www.paws-r-sdk.com/docs/opensearchingestion_get_pipeline_change_progress/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_get_pipeline_change_progress
opensearchingestion_get_pipeline_change_progress <- function(PipelineName) {
  op <- new_operation(
    name = "GetPipelineChangeProgress",
    http_method = "GET",
    http_path = "/2022-01-01/osis/getPipelineChangeProgress/{PipelineName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$get_pipeline_change_progress_input(PipelineName = PipelineName)
  output <- .opensearchingestion$get_pipeline_change_progress_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$get_pipeline_change_progress <- opensearchingestion_get_pipeline_change_progress

#' Retrieves a list of all available blueprints for Data Prepper
#'
#' @description
#' Retrieves a list of all available blueprints for Data Prepper. For more information, see [Using blueprints to create a pipeline](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html#pipeline-blueprint).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_list_pipeline_blueprints/](https://www.paws-r-sdk.com/docs/opensearchingestion_list_pipeline_blueprints/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname opensearchingestion_list_pipeline_blueprints
opensearchingestion_list_pipeline_blueprints <- function() {
  op <- new_operation(
    name = "ListPipelineBlueprints",
    http_method = "POST",
    http_path = "/2022-01-01/osis/listPipelineBlueprints",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$list_pipeline_blueprints_input()
  output <- .opensearchingestion$list_pipeline_blueprints_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$list_pipeline_blueprints <- opensearchingestion_list_pipeline_blueprints

#' Lists all OpenSearch Ingestion pipelines in the current Amazon Web
#' Services account and Region
#'
#' @description
#' Lists all OpenSearch Ingestion pipelines in the current Amazon Web Services account and Region. For more information, see [Viewing Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/list-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_list_pipelines/](https://www.paws-r-sdk.com/docs/opensearchingestion_list_pipelines/) for full documentation.
#'
#' @param MaxResults An optional parameter that specifies the maximum number of results to
#' return. You can use `nextToken` to get the next page of results.
#' @param NextToken If your initial [`list_pipelines`][opensearchingestion_list_pipelines]
#' operation returns a `nextToken`, you can include the returned
#' `nextToken` in subsequent
#' [`list_pipelines`][opensearchingestion_list_pipelines] operations, which
#' returns results in the next page.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_list_pipelines
opensearchingestion_list_pipelines <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPipelines",
    http_method = "GET",
    http_path = "/2022-01-01/osis/listPipelines",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .opensearchingestion$list_pipelines_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchingestion$list_pipelines_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$list_pipelines <- opensearchingestion_list_pipelines

#' Lists all resource tags associated with an OpenSearch Ingestion pipeline
#'
#' @description
#' Lists all resource tags associated with an OpenSearch Ingestion pipeline. For more information, see [Tagging Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/opensearchingestion_list_tags_for_resource/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline to retrieve tags for.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_list_tags_for_resource
opensearchingestion_list_tags_for_resource <- function(Arn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2022-01-01/osis/listTagsForResource/",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$list_tags_for_resource_input(Arn = Arn)
  output <- .opensearchingestion$list_tags_for_resource_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$list_tags_for_resource <- opensearchingestion_list_tags_for_resource

#' Starts an OpenSearch Ingestion pipeline
#'
#' @description
#' Starts an OpenSearch Ingestion pipeline. For more information, see [Starting an OpenSearch Ingestion pipeline](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--start).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_start_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_start_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to start.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_start_pipeline
opensearchingestion_start_pipeline <- function(PipelineName) {
  op <- new_operation(
    name = "StartPipeline",
    http_method = "PUT",
    http_path = "/2022-01-01/osis/startPipeline/{PipelineName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$start_pipeline_input(PipelineName = PipelineName)
  output <- .opensearchingestion$start_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$start_pipeline <- opensearchingestion_start_pipeline

#' Stops an OpenSearch Ingestion pipeline
#'
#' @description
#' Stops an OpenSearch Ingestion pipeline. For more information, see [Stopping an OpenSearch Ingestion pipeline](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/pipeline--stop-start.html#pipeline--stop).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_stop_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_stop_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to stop.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_stop_pipeline
opensearchingestion_stop_pipeline <- function(PipelineName) {
  op <- new_operation(
    name = "StopPipeline",
    http_method = "PUT",
    http_path = "/2022-01-01/osis/stopPipeline/{PipelineName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$stop_pipeline_input(PipelineName = PipelineName)
  output <- .opensearchingestion$stop_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$stop_pipeline <- opensearchingestion_stop_pipeline

#' Tags an OpenSearch Ingestion pipeline
#'
#' @description
#' Tags an OpenSearch Ingestion pipeline. For more information, see [Tagging Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_tag_resource/](https://www.paws-r-sdk.com/docs/opensearchingestion_tag_resource/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline to tag.
#' @param Tags &#91;required&#93; The list of key-value tags to add to the pipeline.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_tag_resource
opensearchingestion_tag_resource <- function(Arn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2022-01-01/osis/tagResource/",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$tag_resource_input(Arn = Arn, Tags = Tags)
  output <- .opensearchingestion$tag_resource_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$tag_resource <- opensearchingestion_tag_resource

#' Removes one or more tags from an OpenSearch Ingestion pipeline
#'
#' @description
#' Removes one or more tags from an OpenSearch Ingestion pipeline. For more information, see [Tagging Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_untag_resource/](https://www.paws-r-sdk.com/docs/opensearchingestion_untag_resource/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the pipeline to remove tags from.
#' @param TagKeys &#91;required&#93; The tag keys to remove.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_untag_resource
opensearchingestion_untag_resource <- function(Arn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/2022-01-01/osis/untagResource/",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$untag_resource_input(Arn = Arn, TagKeys = TagKeys)
  output <- .opensearchingestion$untag_resource_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$untag_resource <- opensearchingestion_untag_resource

#' Updates an OpenSearch Ingestion pipeline
#'
#' @description
#' Updates an OpenSearch Ingestion pipeline. For more information, see [Updating Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/update-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_update_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_update_pipeline/) for full documentation.
#'
#' @param PipelineName &#91;required&#93; The name of the pipeline to update.
#' @param MinUnits The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
#' @param MaxUnits The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
#' @param PipelineConfigurationBody The pipeline configuration in YAML format. The command accepts the
#' pipeline configuration as a string or within a .yaml file. If you
#' provide the configuration as a string, each new line must be escaped
#' with `\\n`.
#' @param LogPublishingOptions Key-value pairs to configure log publishing.
#' @param BufferOptions Key-value pairs to configure persistent buffering for the pipeline.
#' @param EncryptionAtRestOptions Key-value pairs to configure encryption for data that is written to a
#' persistent buffer.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_update_pipeline
opensearchingestion_update_pipeline <- function(PipelineName, MinUnits = NULL, MaxUnits = NULL, PipelineConfigurationBody = NULL, LogPublishingOptions = NULL, BufferOptions = NULL, EncryptionAtRestOptions = NULL) {
  op <- new_operation(
    name = "UpdatePipeline",
    http_method = "PUT",
    http_path = "/2022-01-01/osis/updatePipeline/{PipelineName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$update_pipeline_input(PipelineName = PipelineName, MinUnits = MinUnits, MaxUnits = MaxUnits, PipelineConfigurationBody = PipelineConfigurationBody, LogPublishingOptions = LogPublishingOptions, BufferOptions = BufferOptions, EncryptionAtRestOptions = EncryptionAtRestOptions)
  output <- .opensearchingestion$update_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$update_pipeline <- opensearchingestion_update_pipeline

#' Checks whether an OpenSearch Ingestion pipeline configuration is valid
#' prior to creation
#'
#' @description
#' Checks whether an OpenSearch Ingestion pipeline configuration is valid prior to creation. For more information, see [Creating Amazon OpenSearch Ingestion pipelines](https://docs.aws.amazon.com/opensearch-service/latest/developerguide/creating-pipeline.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opensearchingestion_validate_pipeline/](https://www.paws-r-sdk.com/docs/opensearchingestion_validate_pipeline/) for full documentation.
#'
#' @param PipelineConfigurationBody &#91;required&#93; The pipeline configuration in YAML format. The command accepts the
#' pipeline configuration as a string or within a .yaml file. If you
#' provide the configuration as a string, each new line must be escaped
#' with `\\n`.
#'
#' @keywords internal
#'
#' @rdname opensearchingestion_validate_pipeline
opensearchingestion_validate_pipeline <- function(PipelineConfigurationBody) {
  op <- new_operation(
    name = "ValidatePipeline",
    http_method = "POST",
    http_path = "/2022-01-01/osis/validatePipeline",
    host_prefix = "",
    paginator = list()
  )
  input <- .opensearchingestion$validate_pipeline_input(PipelineConfigurationBody = PipelineConfigurationBody)
  output <- .opensearchingestion$validate_pipeline_output()
  config <- get_config()
  svc <- .opensearchingestion$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchingestion$operations$validate_pipeline <- opensearchingestion_validate_pipeline
