% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_databases}
\alias{glue_get_databases}
\title{Retrieves all databases defined in a given Data Catalog}
\usage{
glue_get_databases(
  CatalogId = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  ResourceShareType = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog from which to retrieve \code{Databases}. If none
is provided, the Amazon Web Services account ID is used by default.}

\item{NextToken}{A continuation token, if this is a continuation call.}

\item{MaxResults}{The maximum number of databases to return in one response.}

\item{ResourceShareType}{Allows you to specify that you want to list the databases shared with
your account. The allowable values are \code{FEDERATED}, \code{FOREIGN} or \code{ALL}.
\itemize{
\item If set to \code{FEDERATED}, will list the federated databases
(referencing an external entity) shared with your account.
\item If set to \code{FOREIGN}, will list the databases shared with your
account.
\item If set to \code{ALL}, will list the databases shared with your account,
as well as the databases in yor local account.
}}
}
\description{
Retrieves all databases defined in a given Data Catalog.

See \url{https://www.paws-r-sdk.com/docs/glue_get_databases/} for full documentation.
}
\keyword{internal}
