% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_notebook_sessions}
\alias{athena_list_notebook_sessions}
\title{Lists, in descending order, the sessions that have been created in a
notebook that are in an active state like CREATING, CREATED, IDLE or
BUSY}
\usage{
athena_list_notebook_sessions(NotebookId, MaxResults = NULL, NextToken = NULL)
}
\arguments{
\item{NotebookId}{[required] The ID of the notebook to list sessions for.}

\item{MaxResults}{The maximum number of notebook sessions to return.}

\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}
}
\description{
Lists, in descending order, the sessions that have been created in a notebook that are in an active state like \code{CREATING}, \code{CREATED}, \code{IDLE} or \code{BUSY}. Newer sessions are listed first; older sessions are listed later.

See \url{https://www.paws-r-sdk.com/docs/athena_list_notebook_sessions/} for full documentation.
}
\keyword{internal}
