% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_subscription_grants}
\alias{datazone_list_subscription_grants}
\title{Lists subscription grants}
\usage{
datazone_list_subscription_grants(
  domainIdentifier,
  environmentId = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  subscribedListingId = NULL,
  subscriptionId = NULL,
  subscriptionTargetId = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{environmentId}{The identifier of the Amazon DataZone environment.}

\item{maxResults}{The maximum number of subscription grants to return in a single call to
\code{\link[=datazone_list_subscription_grants]{list_subscription_grants}}. When
the number of subscription grants to be listed is greater than the value
of \code{MaxResults}, the response contains a \code{NextToken} value that you can
use in a subsequent call to
\code{\link[=datazone_list_subscription_grants]{list_subscription_grants}} to list
the next set of subscription grants.}

\item{nextToken}{When the number of subscription grants is greater than the default value
for the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of subscription grants, the
response includes a pagination token named \code{NextToken}. You can specify
this \code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_subscription_grants]{list_subscription_grants}} to list
the next set of subscription grants.}

\item{sortBy}{Specifies the way of sorting the results of this action.}

\item{sortOrder}{Specifies the sort order of this action.}

\item{subscribedListingId}{The identifier of the subscribed listing.}

\item{subscriptionId}{The identifier of the subscription.}

\item{subscriptionTargetId}{The identifier of the subscription target.}
}
\description{
Lists subscription grants.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_subscription_grants/} for full documentation.
}
\keyword{internal}
