% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_import_notebook}
\alias{athena_import_notebook}
\title{Imports a single ipynb file to a Spark enabled workgroup}
\usage{
athena_import_notebook(
  WorkGroup,
  Name,
  Payload,
  Type,
  ClientRequestToken = NULL
)
}
\arguments{
\item{WorkGroup}{[required] The name of the Spark enabled workgroup to import the notebook to.}

\item{Name}{[required] The name of the notebook to import.}

\item{Payload}{[required] The notebook content to be imported.}

\item{Type}{[required] The notebook content type. Currently, the only valid type is \code{IPYNB}.}

\item{ClientRequestToken}{A unique case-sensitive string used to ensure the request to import the
notebook is idempotent (executes only once).

This token is listed as not required because Amazon Web Services SDKs
(for example the Amazon Web Services SDK for Java) auto-generate the
token for you. If you are not using the Amazon Web Services SDK or the
Amazon Web Services CLI, you must provide this token or the action will
fail.}
}
\description{
Imports a single \code{ipynb} file to a Spark enabled workgroup. The maximum file size that can be imported is 10 megabytes. If an \code{ipynb} file with the same name already exists in the workgroup, throws an error.

See \url{https://www.paws-r-sdk.com/docs/athena_import_notebook/} for full documentation.
}
\keyword{internal}
