# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Athena
#'
#' @description
#' Amazon Athena is an interactive query service that lets you use standard
#' SQL to analyze data directly in Amazon S3. You can point Athena at your
#' data in Amazon S3 and run ad-hoc queries and get results in seconds.
#' Athena is serverless, so there is no infrastructure to set up or manage.
#' You pay only for the queries you run. Athena scales
#' automatically—executing queries in parallel—so results are fast, even
#' with large datasets and complex queries. For more information, see [What
#' is Amazon
#' Athena](https://docs.aws.amazon.com/athena/latest/ug/what-is.html) in
#' the *Amazon Athena User Guide*.
#' 
#' If you connect to Athena using the JDBC driver, use version 1.1.0 of the
#' driver or later with the Amazon Athena API. Earlier version drivers do
#' not support the API. For more information and to download the driver,
#' see [Accessing Amazon Athena with
#' JDBC](https://docs.aws.amazon.com/athena/latest/ug/connect-with-jdbc.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- athena(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- athena()
#' svc$batch_get_named_query(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=athena_batch_get_named_query]{batch_get_named_query} \tab Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings\cr
#'  \link[=athena_batch_get_prepared_statement]{batch_get_prepared_statement} \tab Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide\cr
#'  \link[=athena_batch_get_query_execution]{batch_get_query_execution} \tab Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings\cr
#'  \link[=athena_cancel_capacity_reservation]{cancel_capacity_reservation} \tab Cancels the capacity reservation with the specified name\cr
#'  \link[=athena_create_capacity_reservation]{create_capacity_reservation} \tab Creates a capacity reservation with the specified name and number of requested data processing units\cr
#'  \link[=athena_create_data_catalog]{create_data_catalog} \tab Creates (registers) a data catalog with the specified name and properties\cr
#'  \link[=athena_create_named_query]{create_named_query} \tab Creates a named query in the specified workgroup\cr
#'  \link[=athena_create_notebook]{create_notebook} \tab Creates an empty ipynb file in the specified Apache Spark enabled workgroup\cr
#'  \link[=athena_create_prepared_statement]{create_prepared_statement} \tab Creates a prepared statement for use with SQL queries in Athena\cr
#'  \link[=athena_create_presigned_notebook_url]{create_presigned_notebook_url} \tab Gets an authentication token and the URL at which the notebook can be accessed\cr
#'  \link[=athena_create_work_group]{create_work_group} \tab Creates a workgroup with the specified name\cr
#'  \link[=athena_delete_capacity_reservation]{delete_capacity_reservation} \tab Deletes a cancelled capacity reservation\cr
#'  \link[=athena_delete_data_catalog]{delete_data_catalog} \tab Deletes a data catalog\cr
#'  \link[=athena_delete_named_query]{delete_named_query} \tab Deletes the named query if you have access to the workgroup in which the query was saved\cr
#'  \link[=athena_delete_notebook]{delete_notebook} \tab Deletes the specified notebook\cr
#'  \link[=athena_delete_prepared_statement]{delete_prepared_statement} \tab Deletes the prepared statement with the specified name from the specified workgroup\cr
#'  \link[=athena_delete_work_group]{delete_work_group} \tab Deletes the workgroup with the specified name\cr
#'  \link[=athena_export_notebook]{export_notebook} \tab Exports the specified notebook and its metadata\cr
#'  \link[=athena_get_calculation_execution]{get_calculation_execution} \tab Describes a previously submitted calculation execution\cr
#'  \link[=athena_get_calculation_execution_code]{get_calculation_execution_code} \tab Retrieves the unencrypted code that was executed for the calculation\cr
#'  \link[=athena_get_calculation_execution_status]{get_calculation_execution_status} \tab Gets the status of a current calculation\cr
#'  \link[=athena_get_capacity_assignment_configuration]{get_capacity_assignment_configuration} \tab Gets the capacity assignment configuration for a capacity reservation, if one exists\cr
#'  \link[=athena_get_capacity_reservation]{get_capacity_reservation} \tab Returns information about the capacity reservation with the specified name\cr
#'  \link[=athena_get_database]{get_database} \tab Returns a database object for the specified database and data catalog\cr
#'  \link[=athena_get_data_catalog]{get_data_catalog} \tab Returns the specified data catalog\cr
#'  \link[=athena_get_named_query]{get_named_query} \tab Returns information about a single query\cr
#'  \link[=athena_get_notebook_metadata]{get_notebook_metadata} \tab Retrieves notebook metadata for the specified notebook ID\cr
#'  \link[=athena_get_prepared_statement]{get_prepared_statement} \tab Retrieves the prepared statement with the specified name from the specified workgroup\cr
#'  \link[=athena_get_query_execution]{get_query_execution} \tab Returns information about a single execution of a query if you have access to the workgroup in which the query ran\cr
#'  \link[=athena_get_query_results]{get_query_results} \tab Streams the results of a single query execution specified by QueryExecutionId from the Athena query results location in Amazon S3\cr
#'  \link[=athena_get_query_runtime_statistics]{get_query_runtime_statistics} \tab Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran\cr
#'  \link[=athena_get_session]{get_session} \tab Gets the full details of a previously created session, including the session status and configuration\cr
#'  \link[=athena_get_session_status]{get_session_status} \tab Gets the current status of a session\cr
#'  \link[=athena_get_table_metadata]{get_table_metadata} \tab Returns table metadata for the specified catalog, database, and table\cr
#'  \link[=athena_get_work_group]{get_work_group} \tab Returns information about the workgroup with the specified name\cr
#'  \link[=athena_import_notebook]{import_notebook} \tab Imports a single ipynb file to a Spark enabled workgroup\cr
#'  \link[=athena_list_application_dpu_sizes]{list_application_dpu_sizes} \tab Returns the supported DPU sizes for the supported application runtimes (for example, Athena notebook version 1)\cr
#'  \link[=athena_list_calculation_executions]{list_calculation_executions} \tab Lists the calculations that have been submitted to a session in descending order\cr
#'  \link[=athena_list_capacity_reservations]{list_capacity_reservations} \tab Lists the capacity reservations for the current account\cr
#'  \link[=athena_list_databases]{list_databases} \tab Lists the databases in the specified data catalog\cr
#'  \link[=athena_list_data_catalogs]{list_data_catalogs} \tab Lists the data catalogs in the current Amazon Web Services account\cr
#'  \link[=athena_list_engine_versions]{list_engine_versions} \tab Returns a list of engine versions that are available to choose from, including the Auto option\cr
#'  \link[=athena_list_executors]{list_executors} \tab Lists, in descending order, the executors that joined a session\cr
#'  \link[=athena_list_named_queries]{list_named_queries} \tab Provides a list of available query IDs only for queries saved in the specified workgroup\cr
#'  \link[=athena_list_notebook_metadata]{list_notebook_metadata} \tab Displays the notebook files for the specified workgroup in paginated format\cr
#'  \link[=athena_list_notebook_sessions]{list_notebook_sessions} \tab Lists, in descending order, the sessions that have been created in a notebook that are in an active state like CREATING, CREATED, IDLE or BUSY\cr
#'  \link[=athena_list_prepared_statements]{list_prepared_statements} \tab Lists the prepared statements in the specified workgroup\cr
#'  \link[=athena_list_query_executions]{list_query_executions} \tab Provides a list of available query execution IDs for the queries in the specified workgroup\cr
#'  \link[=athena_list_sessions]{list_sessions} \tab Lists the sessions in a workgroup that are in an active state like CREATING, CREATED, IDLE, or BUSY\cr
#'  \link[=athena_list_table_metadata]{list_table_metadata} \tab Lists the metadata for the tables in the specified data catalog database\cr
#'  \link[=athena_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags associated with an Athena resource\cr
#'  \link[=athena_list_work_groups]{list_work_groups} \tab Lists available workgroups for the account\cr
#'  \link[=athena_put_capacity_assignment_configuration]{put_capacity_assignment_configuration} \tab Puts a new capacity assignment configuration for a specified capacity reservation\cr
#'  \link[=athena_start_calculation_execution]{start_calculation_execution} \tab Submits calculations for execution within a session\cr
#'  \link[=athena_start_query_execution]{start_query_execution} \tab Runs the SQL query statements contained in the Query\cr
#'  \link[=athena_start_session]{start_session} \tab Creates a session for running calculations within a workgroup\cr
#'  \link[=athena_stop_calculation_execution]{stop_calculation_execution} \tab Requests the cancellation of a calculation\cr
#'  \link[=athena_stop_query_execution]{stop_query_execution} \tab Stops a query execution\cr
#'  \link[=athena_tag_resource]{tag_resource} \tab Adds one or more tags to an Athena resource\cr
#'  \link[=athena_terminate_session]{terminate_session} \tab Terminates an active session\cr
#'  \link[=athena_untag_resource]{untag_resource} \tab Removes one or more tags from an Athena resource\cr
#'  \link[=athena_update_capacity_reservation]{update_capacity_reservation} \tab Updates the number of requested data processing units for the capacity reservation with the specified name\cr
#'  \link[=athena_update_data_catalog]{update_data_catalog} \tab Updates the data catalog that has the specified name\cr
#'  \link[=athena_update_named_query]{update_named_query} \tab Updates a NamedQuery object\cr
#'  \link[=athena_update_notebook]{update_notebook} \tab Updates the contents of a Spark notebook\cr
#'  \link[=athena_update_notebook_metadata]{update_notebook_metadata} \tab Updates the metadata for a notebook\cr
#'  \link[=athena_update_prepared_statement]{update_prepared_statement} \tab Updates a prepared statement\cr
#'  \link[=athena_update_work_group]{update_work_group} \tab Updates the workgroup with the specified name
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname athena
#' @export
athena <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .athena$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.athena <- list()

.athena$operations <- list()

.athena$metadata <- list(
  service_name = "athena",
  endpoints = list("*" = list(endpoint = "athena.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "athena.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "athena.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "athena.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Athena",
  api_version = "2017-05-18",
  signing_name = "athena",
  json_version = "1.1",
  target_prefix = "AmazonAthena"
)

.athena$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.athena$metadata, handlers, config)
}
