# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon CloudSearch Domain
#'
#' @description
#' You use the AmazonCloudSearch2013 API to upload documents to a search
#' domain and search those documents.
#' 
#' The endpoints for submitting
#' [`upload_documents`][cloudsearchdomain_upload_documents],
#' [`search`][cloudsearchdomain_search], and
#' [`suggest`][cloudsearchdomain_suggest] requests are domain-specific. To
#' get the endpoints for your domain, use the Amazon CloudSearch
#' configuration service `DescribeDomains` action. The domain endpoints are
#' also displayed on the domain dashboard in the Amazon CloudSearch
#' console. You submit suggest requests to the search endpoint.
#' 
#' For more information, see the [Amazon CloudSearch Developer
#' Guide](https://docs.aws.amazon.com/cloudsearch/latest/developerguide/).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudsearchdomain(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudsearchdomain()
#' svc$search(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudsearchdomain_search]{search} \tab Retrieves a list of documents that match the specified search criteria\cr
#'  \link[=cloudsearchdomain_suggest]{suggest} \tab Retrieves autocomplete suggestions for a partial query string\cr
#'  \link[=cloudsearchdomain_upload_documents]{upload_documents} \tab Posts a batch of documents to a search domain for indexing
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloudsearchdomain
#' @export
cloudsearchdomain <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .cloudsearchdomain$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudsearchdomain <- list()

.cloudsearchdomain$operations <- list()

.cloudsearchdomain$metadata <- list(
  service_name = "cloudsearchdomain",
  endpoints = list("*" = list(endpoint = "cloudsearchdomain.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloudsearchdomain.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cloudsearchdomain.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cloudsearchdomain.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "CloudSearch Domain",
  api_version = "2013-01-01",
  signing_name = "cloudsearch",
  json_version = "1.1",
  target_prefix = ""
)

.cloudsearchdomain$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.cloudsearchdomain$metadata, handlers, config)
}
