% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_account_customization}
\alias{quicksight_create_account_customization}
\title{Creates Amazon QuickSight customizations for the current Amazon Web
Services Region}
\usage{
quicksight_create_account_customization(
  AwsAccountId,
  Namespace = NULL,
  AccountCustomization,
  Tags = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the Amazon Web Services account that you want to customize
Amazon QuickSight for.}

\item{Namespace}{The Amazon QuickSight namespace that you want to add customizations to.}

\item{AccountCustomization}{[required] The Amazon QuickSight customizations you're adding in the current Amazon
Web Services Region. You can add these to an Amazon Web Services account
and a QuickSight namespace.

For example, you can add a default theme by setting
\code{AccountCustomization} to the midnight theme:
\code{"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight::aws:theme/MIDNIGHT" }}.
Or, you can add a custom theme by specifying
\code{"AccountCustomization": { "DefaultTheme": "arn:aws:quicksight:us-west-2:111122223333:theme/bdb844d0-0fe9-4d9d-b520-0fe602d93639" }}.}

\item{Tags}{A list of the tags that you want to attach to this resource.}
}
\description{
Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the \code{\link[=quicksight_create_account_customization]{create_account_customization}} or \code{\link[=quicksight_update_account_customization]{update_account_customization}} API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see \href{https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html}{Customizing Amazon QuickSight} in the \emph{Amazon QuickSight User Guide.}

See \url{https://www.paws-r-sdk.com/docs/quicksight_create_account_customization/} for full documentation.
}
\keyword{internal}
