# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include athena_service.R
NULL

#' Returns the details of a single named query or a list of up to 50
#' queries, which you provide as an array of query ID strings
#'
#' @description
#' Returns the details of a single named query or a list of up to 50 queries, which you provide as an array of query ID strings. Requires you to have access to the workgroup in which the queries were saved. Use ListNamedQueriesInput to get the list of named query IDs in the specified workgroup. If information could not be retrieved for a submitted query ID, information about the query ID submitted is listed under UnprocessedNamedQueryId. Named queries differ from executed queries. Use BatchGetQueryExecutionInput to get details about each unique query execution, and ListQueryExecutionsInput to get a list of query execution IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_batch_get_named_query/](https://www.paws-r-sdk.com/docs/athena_batch_get_named_query/) for full documentation.
#'
#' @param NamedQueryIds &#91;required&#93; An array of query IDs.
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_named_query
athena_batch_get_named_query <- function(NamedQueryIds) {
  op <- new_operation(
    name = "BatchGetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_named_query_input(NamedQueryIds = NamedQueryIds)
  output <- .athena$batch_get_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_named_query <- athena_batch_get_named_query

#' Returns the details of a single prepared statement or a list of up to
#' 256 prepared statements for the array of prepared statement names that
#' you provide
#'
#' @description
#' Returns the details of a single prepared statement or a list of up to 256 prepared statements for the array of prepared statement names that you provide. Requires you to have access to the workgroup to which the prepared statements belong. If a prepared statement cannot be retrieved for the name specified, the statement is listed in `UnprocessedPreparedStatementNames`.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_batch_get_prepared_statement/](https://www.paws-r-sdk.com/docs/athena_batch_get_prepared_statement/) for full documentation.
#'
#' @param PreparedStatementNames &#91;required&#93; A list of prepared statement names to return.
#' @param WorkGroup &#91;required&#93; The name of the workgroup to which the prepared statements belong.
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_prepared_statement
athena_batch_get_prepared_statement <- function(PreparedStatementNames, WorkGroup) {
  op <- new_operation(
    name = "BatchGetPreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_prepared_statement_input(PreparedStatementNames = PreparedStatementNames, WorkGroup = WorkGroup)
  output <- .athena$batch_get_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_prepared_statement <- athena_batch_get_prepared_statement

#' Returns the details of a single query execution or a list of up to 50
#' query executions, which you provide as an array of query execution ID
#' strings
#'
#' @description
#' Returns the details of a single query execution or a list of up to 50 query executions, which you provide as an array of query execution ID strings. Requires you to have access to the workgroup in which the queries ran. To get a list of query execution IDs, use ListQueryExecutionsInput$WorkGroup. Query executions differ from named (saved) queries. Use BatchGetNamedQueryInput to get details about named queries.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_batch_get_query_execution/](https://www.paws-r-sdk.com/docs/athena_batch_get_query_execution/) for full documentation.
#'
#' @param QueryExecutionIds &#91;required&#93; An array of query execution IDs.
#'
#' @keywords internal
#'
#' @rdname athena_batch_get_query_execution
athena_batch_get_query_execution <- function(QueryExecutionIds) {
  op <- new_operation(
    name = "BatchGetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$batch_get_query_execution_input(QueryExecutionIds = QueryExecutionIds)
  output <- .athena$batch_get_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$batch_get_query_execution <- athena_batch_get_query_execution

#' Cancels the capacity reservation with the specified name
#'
#' @description
#' Cancels the capacity reservation with the specified name. Cancelled reservations remain in your account and will be deleted 45 days after cancellation. During the 45 days, you cannot re-purpose or reuse a reservation that has been cancelled, but you can refer to its tags and view it for historical reference.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_cancel_capacity_reservation/](https://www.paws-r-sdk.com/docs/athena_cancel_capacity_reservation/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the capacity reservation to cancel.
#'
#' @keywords internal
#'
#' @rdname athena_cancel_capacity_reservation
athena_cancel_capacity_reservation <- function(Name) {
  op <- new_operation(
    name = "CancelCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$cancel_capacity_reservation_input(Name = Name)
  output <- .athena$cancel_capacity_reservation_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$cancel_capacity_reservation <- athena_cancel_capacity_reservation

#' Creates a capacity reservation with the specified name and number of
#' requested data processing units
#'
#' @description
#' Creates a capacity reservation with the specified name and number of requested data processing units.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_capacity_reservation/](https://www.paws-r-sdk.com/docs/athena_create_capacity_reservation/) for full documentation.
#'
#' @param TargetDpus &#91;required&#93; The number of requested data processing units.
#' @param Name &#91;required&#93; The name of the capacity reservation to create.
#' @param Tags The tags for the capacity reservation.
#'
#' @keywords internal
#'
#' @rdname athena_create_capacity_reservation
athena_create_capacity_reservation <- function(TargetDpus, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_capacity_reservation_input(TargetDpus = TargetDpus, Name = Name, Tags = Tags)
  output <- .athena$create_capacity_reservation_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_capacity_reservation <- athena_create_capacity_reservation

#' Creates (registers) a data catalog with the specified name and
#' properties
#'
#' @description
#' Creates (registers) a data catalog with the specified name and properties. Catalogs created are visible to all users of the same Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_data_catalog/](https://www.paws-r-sdk.com/docs/athena_create_data_catalog/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to create. The catalog name must be unique
#' for the Amazon Web Services account and can use a maximum of 127
#' alphanumeric, underscore, at sign, or hyphen characters. The remainder
#' of the length constraint of 256 is reserved for use by Athena.
#' @param Type &#91;required&#93; The type of data catalog to create: `LAMBDA` for a federated catalog,
#' `HIVE` for an external hive metastore, or `GLUE` for an Glue Data
#' Catalog.
#' @param Description A description of the data catalog to be created.
#' @param Parameters Specifies the Lambda function or functions to use for creating the data
#' catalog. This is a mapping whose values depend on the catalog type.
#' 
#' -   For the `HIVE` data catalog type, use the following syntax. The
#'     `metadata-function` parameter is required. `The sdk-version`
#'     parameter is optional and defaults to the currently supported
#'     version.
#' 
#'     `metadata-function=lambda_arn, sdk-version=version_number `
#' 
#' -   For the `LAMBDA` data catalog type, use one of the following sets of
#'     required parameters, but not both.
#' 
#'     -   If you have one Lambda function that processes metadata and
#'         another for reading the actual data, use the following syntax.
#'         Both parameters are required.
#' 
#'         `metadata-function=lambda_arn, record-function=lambda_arn `
#' 
#'     -   If you have a composite Lambda function that processes both
#'         metadata and data, use the following syntax to specify your
#'         Lambda function.
#' 
#'         `function=lambda_arn `
#' 
#' -   The `GLUE` type takes a catalog ID parameter and is required. The
#'     ` catalog_id ` is the account ID of the Amazon Web Services account
#'     to which the Glue Data Catalog belongs.
#' 
#'     `catalog-id=catalog_id `
#' 
#'     -   The `GLUE` data catalog type also applies to the default
#'         `AwsDataCatalog` that already exists in your account, of which
#'         you can have only one and cannot modify.
#' 
#'     -   Queries that specify a Glue Data Catalog other than the default
#'         `AwsDataCatalog` must be run on Athena engine version 2.
#' 
#'     -   In Regions where Athena engine version 2 is not available,
#'         creating new Glue data catalogs results in an `INVALID_INPUT`
#'         error.
#' @param Tags A list of comma separated tags to add to the data catalog that is
#' created.
#'
#' @keywords internal
#'
#' @rdname athena_create_data_catalog
athena_create_data_catalog <- function(Name, Type, Description = NULL, Parameters = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_data_catalog_input(Name = Name, Type = Type, Description = Description, Parameters = Parameters, Tags = Tags)
  output <- .athena$create_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_data_catalog <- athena_create_data_catalog

#' Creates a named query in the specified workgroup
#'
#' @description
#' Creates a named query in the specified workgroup. Requires that you have access to the workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_named_query/](https://www.paws-r-sdk.com/docs/athena_create_named_query/) for full documentation.
#'
#' @param Name &#91;required&#93; The query name.
#' @param Description The query description.
#' @param Database &#91;required&#93; The database to which the query belongs.
#' @param QueryString &#91;required&#93; The contents of the query with all query statements.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another
#' [`create_named_query`][athena_create_named_query] request is received,
#' the same response is returned and another query is not created. If a
#' parameter has changed, for example, the `QueryString`, an error is
#' returned.
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for users. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#' @param WorkGroup The name of the workgroup in which the named query is being created.
#'
#' @keywords internal
#'
#' @rdname athena_create_named_query
athena_create_named_query <- function(Name, Description = NULL, Database, QueryString, ClientRequestToken = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "CreateNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_named_query_input(Name = Name, Description = Description, Database = Database, QueryString = QueryString, ClientRequestToken = ClientRequestToken, WorkGroup = WorkGroup)
  output <- .athena$create_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_named_query <- athena_create_named_query

#' Creates an empty ipynb file in the specified Apache Spark enabled
#' workgroup
#'
#' @description
#' Creates an empty `ipynb` file in the specified Apache Spark enabled workgroup. Throws an error if a file in the workgroup with the same name already exists.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_notebook/](https://www.paws-r-sdk.com/docs/athena_create_notebook/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The name of the Spark enabled workgroup in which the notebook will be
#' created.
#' @param Name &#91;required&#93; The name of the `ipynb` file to be created in the Spark workgroup,
#' without the `.ipynb` extension.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' notebook is idempotent (executes only once).
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for you. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#'
#' @keywords internal
#'
#' @rdname athena_create_notebook
athena_create_notebook <- function(WorkGroup, Name, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "CreateNotebook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_notebook_input(WorkGroup = WorkGroup, Name = Name, ClientRequestToken = ClientRequestToken)
  output <- .athena$create_notebook_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_notebook <- athena_create_notebook

#' Creates a prepared statement for use with SQL queries in Athena
#'
#' @description
#' Creates a prepared statement for use with SQL queries in Athena.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_prepared_statement/](https://www.paws-r-sdk.com/docs/athena_create_prepared_statement/) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement.
#' @param WorkGroup &#91;required&#93; The name of the workgroup to which the prepared statement belongs.
#' @param QueryStatement &#91;required&#93; The query string for the prepared statement.
#' @param Description The description of the prepared statement.
#'
#' @keywords internal
#'
#' @rdname athena_create_prepared_statement
athena_create_prepared_statement <- function(StatementName, WorkGroup, QueryStatement, Description = NULL) {
  op <- new_operation(
    name = "CreatePreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup, QueryStatement = QueryStatement, Description = Description)
  output <- .athena$create_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_prepared_statement <- athena_create_prepared_statement

#' Gets an authentication token and the URL at which the notebook can be
#' accessed
#'
#' @description
#' Gets an authentication token and the URL at which the notebook can be accessed. During programmatic access, [`create_presigned_notebook_url`][athena_create_presigned_notebook_url] must be called every 10 minutes to refresh the authentication token. For information about granting programmatic access, see [Grant programmatic access](https://docs.aws.amazon.com/athena/latest/ug/setting-up.html#setting-up-grant-programmatic-access).
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_presigned_notebook_url/](https://www.paws-r-sdk.com/docs/athena_create_presigned_notebook_url/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#'
#' @keywords internal
#'
#' @rdname athena_create_presigned_notebook_url
athena_create_presigned_notebook_url <- function(SessionId) {
  op <- new_operation(
    name = "CreatePresignedNotebookUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_presigned_notebook_url_input(SessionId = SessionId)
  output <- .athena$create_presigned_notebook_url_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_presigned_notebook_url <- athena_create_presigned_notebook_url

#' Creates a workgroup with the specified name
#'
#' @description
#' Creates a workgroup with the specified name. A workgroup can be an Apache Spark enabled workgroup or an Athena SQL workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_create_work_group/](https://www.paws-r-sdk.com/docs/athena_create_work_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The workgroup name.
#' @param Configuration Contains configuration information for creating an Athena SQL workgroup
#' or Spark enabled Athena workgroup. Athena SQL workgroup configuration
#' includes the location in Amazon S3 where query and calculation results
#' are stored, the encryption configuration, if any, used for encrypting
#' query results, whether the Amazon CloudWatch Metrics are enabled for the
#' workgroup, the limit for the amount of bytes scanned (cutoff) per query,
#' if it is specified, and whether workgroup's settings (specified with
#' `EnforceWorkGroupConfiguration`) in the `WorkGroupConfiguration`
#' override client-side settings. See
#' WorkGroupConfiguration$EnforceWorkGroupConfiguration.
#' @param Description The workgroup description.
#' @param Tags A list of comma separated tags to add to the workgroup that is created.
#'
#' @keywords internal
#'
#' @rdname athena_create_work_group
athena_create_work_group <- function(Name, Configuration = NULL, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$create_work_group_input(Name = Name, Configuration = Configuration, Description = Description, Tags = Tags)
  output <- .athena$create_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$create_work_group <- athena_create_work_group

#' Deletes a cancelled capacity reservation
#'
#' @description
#' Deletes a cancelled capacity reservation. A reservation must be cancelled before it can be deleted. A deleted reservation is immediately removed from your account and can no longer be referenced, including by its ARN. A deleted reservation cannot be called by [`get_capacity_reservation`][athena_get_capacity_reservation], and deleted reservations do not appear in the output of [`list_capacity_reservations`][athena_list_capacity_reservations].
#'
#' See [https://www.paws-r-sdk.com/docs/athena_delete_capacity_reservation/](https://www.paws-r-sdk.com/docs/athena_delete_capacity_reservation/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the capacity reservation to delete.
#'
#' @keywords internal
#'
#' @rdname athena_delete_capacity_reservation
athena_delete_capacity_reservation <- function(Name) {
  op <- new_operation(
    name = "DeleteCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_capacity_reservation_input(Name = Name)
  output <- .athena$delete_capacity_reservation_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_capacity_reservation <- athena_delete_capacity_reservation

#' Deletes a data catalog
#'
#' @description
#' Deletes a data catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_delete_data_catalog/](https://www.paws-r-sdk.com/docs/athena_delete_data_catalog/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to delete.
#'
#' @keywords internal
#'
#' @rdname athena_delete_data_catalog
athena_delete_data_catalog <- function(Name) {
  op <- new_operation(
    name = "DeleteDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_data_catalog_input(Name = Name)
  output <- .athena$delete_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_data_catalog <- athena_delete_data_catalog

#' Deletes the named query if you have access to the workgroup in which the
#' query was saved
#'
#' @description
#' Deletes the named query if you have access to the workgroup in which the query was saved.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_delete_named_query/](https://www.paws-r-sdk.com/docs/athena_delete_named_query/) for full documentation.
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query to delete.
#'
#' @keywords internal
#'
#' @rdname athena_delete_named_query
athena_delete_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "DeleteNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$delete_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_named_query <- athena_delete_named_query

#' Deletes the specified notebook
#'
#' @description
#' Deletes the specified notebook.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_delete_notebook/](https://www.paws-r-sdk.com/docs/athena_delete_notebook/) for full documentation.
#'
#' @param NotebookId &#91;required&#93; The ID of the notebook to delete.
#'
#' @keywords internal
#'
#' @rdname athena_delete_notebook
athena_delete_notebook <- function(NotebookId) {
  op <- new_operation(
    name = "DeleteNotebook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_notebook_input(NotebookId = NotebookId)
  output <- .athena$delete_notebook_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_notebook <- athena_delete_notebook

#' Deletes the prepared statement with the specified name from the
#' specified workgroup
#'
#' @description
#' Deletes the prepared statement with the specified name from the specified workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_delete_prepared_statement/](https://www.paws-r-sdk.com/docs/athena_delete_prepared_statement/) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement to delete.
#' @param WorkGroup &#91;required&#93; The workgroup to which the statement to be deleted belongs.
#'
#' @keywords internal
#'
#' @rdname athena_delete_prepared_statement
athena_delete_prepared_statement <- function(StatementName, WorkGroup) {
  op <- new_operation(
    name = "DeletePreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup)
  output <- .athena$delete_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_prepared_statement <- athena_delete_prepared_statement

#' Deletes the workgroup with the specified name
#'
#' @description
#' Deletes the workgroup with the specified name. The primary workgroup cannot be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_delete_work_group/](https://www.paws-r-sdk.com/docs/athena_delete_work_group/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The unique name of the workgroup to delete.
#' @param RecursiveDeleteOption The option to delete the workgroup and its contents even if the
#' workgroup contains any named queries, query executions, or notebooks.
#'
#' @keywords internal
#'
#' @rdname athena_delete_work_group
athena_delete_work_group <- function(WorkGroup, RecursiveDeleteOption = NULL) {
  op <- new_operation(
    name = "DeleteWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$delete_work_group_input(WorkGroup = WorkGroup, RecursiveDeleteOption = RecursiveDeleteOption)
  output <- .athena$delete_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$delete_work_group <- athena_delete_work_group

#' Exports the specified notebook and its metadata
#'
#' @description
#' Exports the specified notebook and its metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_export_notebook/](https://www.paws-r-sdk.com/docs/athena_export_notebook/) for full documentation.
#'
#' @param NotebookId &#91;required&#93; The ID of the notebook to export.
#'
#' @keywords internal
#'
#' @rdname athena_export_notebook
athena_export_notebook <- function(NotebookId) {
  op <- new_operation(
    name = "ExportNotebook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$export_notebook_input(NotebookId = NotebookId)
  output <- .athena$export_notebook_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$export_notebook <- athena_export_notebook

#' Describes a previously submitted calculation execution
#'
#' @description
#' Describes a previously submitted calculation execution.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_calculation_execution/](https://www.paws-r-sdk.com/docs/athena_get_calculation_execution/) for full documentation.
#'
#' @param CalculationExecutionId &#91;required&#93; The calculation execution UUID.
#'
#' @keywords internal
#'
#' @rdname athena_get_calculation_execution
athena_get_calculation_execution <- function(CalculationExecutionId) {
  op <- new_operation(
    name = "GetCalculationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_calculation_execution_input(CalculationExecutionId = CalculationExecutionId)
  output <- .athena$get_calculation_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_calculation_execution <- athena_get_calculation_execution

#' Retrieves the unencrypted code that was executed for the calculation
#'
#' @description
#' Retrieves the unencrypted code that was executed for the calculation.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_calculation_execution_code/](https://www.paws-r-sdk.com/docs/athena_get_calculation_execution_code/) for full documentation.
#'
#' @param CalculationExecutionId &#91;required&#93; The calculation execution UUID.
#'
#' @keywords internal
#'
#' @rdname athena_get_calculation_execution_code
athena_get_calculation_execution_code <- function(CalculationExecutionId) {
  op <- new_operation(
    name = "GetCalculationExecutionCode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_calculation_execution_code_input(CalculationExecutionId = CalculationExecutionId)
  output <- .athena$get_calculation_execution_code_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_calculation_execution_code <- athena_get_calculation_execution_code

#' Gets the status of a current calculation
#'
#' @description
#' Gets the status of a current calculation.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_calculation_execution_status/](https://www.paws-r-sdk.com/docs/athena_get_calculation_execution_status/) for full documentation.
#'
#' @param CalculationExecutionId &#91;required&#93; The calculation execution UUID.
#'
#' @keywords internal
#'
#' @rdname athena_get_calculation_execution_status
athena_get_calculation_execution_status <- function(CalculationExecutionId) {
  op <- new_operation(
    name = "GetCalculationExecutionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_calculation_execution_status_input(CalculationExecutionId = CalculationExecutionId)
  output <- .athena$get_calculation_execution_status_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_calculation_execution_status <- athena_get_calculation_execution_status

#' Gets the capacity assignment configuration for a capacity reservation,
#' if one exists
#'
#' @description
#' Gets the capacity assignment configuration for a capacity reservation, if one exists.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_capacity_assignment_configuration/](https://www.paws-r-sdk.com/docs/athena_get_capacity_assignment_configuration/) for full documentation.
#'
#' @param CapacityReservationName &#91;required&#93; The name of the capacity reservation to retrieve the capacity assignment
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname athena_get_capacity_assignment_configuration
athena_get_capacity_assignment_configuration <- function(CapacityReservationName) {
  op <- new_operation(
    name = "GetCapacityAssignmentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_capacity_assignment_configuration_input(CapacityReservationName = CapacityReservationName)
  output <- .athena$get_capacity_assignment_configuration_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_capacity_assignment_configuration <- athena_get_capacity_assignment_configuration

#' Returns information about the capacity reservation with the specified
#' name
#'
#' @description
#' Returns information about the capacity reservation with the specified name.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_capacity_reservation/](https://www.paws-r-sdk.com/docs/athena_get_capacity_reservation/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the capacity reservation.
#'
#' @keywords internal
#'
#' @rdname athena_get_capacity_reservation
athena_get_capacity_reservation <- function(Name) {
  op <- new_operation(
    name = "GetCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_capacity_reservation_input(Name = Name)
  output <- .athena$get_capacity_reservation_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_capacity_reservation <- athena_get_capacity_reservation

#' Returns the specified data catalog
#'
#' @description
#' Returns the specified data catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_data_catalog/](https://www.paws-r-sdk.com/docs/athena_get_data_catalog/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to return.
#'
#' @keywords internal
#'
#' @rdname athena_get_data_catalog
athena_get_data_catalog <- function(Name) {
  op <- new_operation(
    name = "GetDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_data_catalog_input(Name = Name)
  output <- .athena$get_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_data_catalog <- athena_get_data_catalog

#' Returns a database object for the specified database and data catalog
#'
#' @description
#' Returns a database object for the specified database and data catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_database/](https://www.paws-r-sdk.com/docs/athena_get_database/) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the database to return.
#' @param DatabaseName &#91;required&#93; The name of the database to return.
#'
#' @keywords internal
#'
#' @rdname athena_get_database
athena_get_database <- function(CatalogName, DatabaseName) {
  op <- new_operation(
    name = "GetDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_database_input(CatalogName = CatalogName, DatabaseName = DatabaseName)
  output <- .athena$get_database_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_database <- athena_get_database

#' Returns information about a single query
#'
#' @description
#' Returns information about a single query. Requires that you have access to the workgroup in which the query was saved.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_named_query/](https://www.paws-r-sdk.com/docs/athena_get_named_query/) for full documentation.
#'
#' @param NamedQueryId &#91;required&#93; The unique ID of the query. Use
#' [`list_named_queries`][athena_list_named_queries] to get query IDs.
#'
#' @keywords internal
#'
#' @rdname athena_get_named_query
athena_get_named_query <- function(NamedQueryId) {
  op <- new_operation(
    name = "GetNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_named_query_input(NamedQueryId = NamedQueryId)
  output <- .athena$get_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_named_query <- athena_get_named_query

#' Retrieves notebook metadata for the specified notebook ID
#'
#' @description
#' Retrieves notebook metadata for the specified notebook ID.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_notebook_metadata/](https://www.paws-r-sdk.com/docs/athena_get_notebook_metadata/) for full documentation.
#'
#' @param NotebookId &#91;required&#93; The ID of the notebook whose metadata is to be retrieved.
#'
#' @keywords internal
#'
#' @rdname athena_get_notebook_metadata
athena_get_notebook_metadata <- function(NotebookId) {
  op <- new_operation(
    name = "GetNotebookMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_notebook_metadata_input(NotebookId = NotebookId)
  output <- .athena$get_notebook_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_notebook_metadata <- athena_get_notebook_metadata

#' Retrieves the prepared statement with the specified name from the
#' specified workgroup
#'
#' @description
#' Retrieves the prepared statement with the specified name from the specified workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_prepared_statement/](https://www.paws-r-sdk.com/docs/athena_get_prepared_statement/) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement to retrieve.
#' @param WorkGroup &#91;required&#93; The workgroup to which the statement to be retrieved belongs.
#'
#' @keywords internal
#'
#' @rdname athena_get_prepared_statement
athena_get_prepared_statement <- function(StatementName, WorkGroup) {
  op <- new_operation(
    name = "GetPreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup)
  output <- .athena$get_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_prepared_statement <- athena_get_prepared_statement

#' Returns information about a single execution of a query if you have
#' access to the workgroup in which the query ran
#'
#' @description
#' Returns information about a single execution of a query if you have access to the workgroup in which the query ran. Each time a query executes, information about the query execution is saved with a unique ID.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_query_execution/](https://www.paws-r-sdk.com/docs/athena_get_query_execution/) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#'
#' @keywords internal
#'
#' @rdname athena_get_query_execution
athena_get_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "GetQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$get_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_execution <- athena_get_query_execution

#' Streams the results of a single query execution specified by
#' QueryExecutionId from the Athena query results location in Amazon S3
#'
#' @description
#' Streams the results of a single query execution specified by `QueryExecutionId` from the Athena query results location in Amazon S3. For more information, see [Working with query results, recent queries, and output files](https://docs.aws.amazon.com/athena/latest/ug/querying.html) in the *Amazon Athena User Guide*. This request does not execute the query but returns results. Use [`start_query_execution`][athena_start_query_execution] to run a query.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_query_results/](https://www.paws-r-sdk.com/docs/athena_get_query_results/) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of results (rows) to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_get_query_results
athena_get_query_results <- function(QueryExecutionId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetQueryResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_results_input(QueryExecutionId = QueryExecutionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$get_query_results_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_results <- athena_get_query_results

#' Returns query execution runtime statistics related to a single execution
#' of a query if you have access to the workgroup in which the query ran
#'
#' @description
#' Returns query execution runtime statistics related to a single execution of a query if you have access to the workgroup in which the query ran. Query execution runtime statistics are returned only when QueryExecutionStatus$State is in a SUCCEEDED or FAILED state. Stage-level input and output row count and data size statistics are not shown when a query has row-level filters defined in Lake Formation.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_query_runtime_statistics/](https://www.paws-r-sdk.com/docs/athena_get_query_runtime_statistics/) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution.
#'
#' @keywords internal
#'
#' @rdname athena_get_query_runtime_statistics
athena_get_query_runtime_statistics <- function(QueryExecutionId) {
  op <- new_operation(
    name = "GetQueryRuntimeStatistics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_query_runtime_statistics_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$get_query_runtime_statistics_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_query_runtime_statistics <- athena_get_query_runtime_statistics

#' Gets the full details of a previously created session, including the
#' session status and configuration
#'
#' @description
#' Gets the full details of a previously created session, including the session status and configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_session/](https://www.paws-r-sdk.com/docs/athena_get_session/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#'
#' @keywords internal
#'
#' @rdname athena_get_session
athena_get_session <- function(SessionId) {
  op <- new_operation(
    name = "GetSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_session_input(SessionId = SessionId)
  output <- .athena$get_session_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_session <- athena_get_session

#' Gets the current status of a session
#'
#' @description
#' Gets the current status of a session.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_session_status/](https://www.paws-r-sdk.com/docs/athena_get_session_status/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#'
#' @keywords internal
#'
#' @rdname athena_get_session_status
athena_get_session_status <- function(SessionId) {
  op <- new_operation(
    name = "GetSessionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_session_status_input(SessionId = SessionId)
  output <- .athena$get_session_status_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_session_status <- athena_get_session_status

#' Returns table metadata for the specified catalog, database, and table
#'
#' @description
#' Returns table metadata for the specified catalog, database, and table.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_table_metadata/](https://www.paws-r-sdk.com/docs/athena_get_table_metadata/) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the database and table
#' metadata to return.
#' @param DatabaseName &#91;required&#93; The name of the database that contains the table metadata to return.
#' @param TableName &#91;required&#93; The name of the table for which metadata is returned.
#'
#' @keywords internal
#'
#' @rdname athena_get_table_metadata
athena_get_table_metadata <- function(CatalogName, DatabaseName, TableName) {
  op <- new_operation(
    name = "GetTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_table_metadata_input(CatalogName = CatalogName, DatabaseName = DatabaseName, TableName = TableName)
  output <- .athena$get_table_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_table_metadata <- athena_get_table_metadata

#' Returns information about the workgroup with the specified name
#'
#' @description
#' Returns information about the workgroup with the specified name.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_get_work_group/](https://www.paws-r-sdk.com/docs/athena_get_work_group/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The name of the workgroup.
#'
#' @keywords internal
#'
#' @rdname athena_get_work_group
athena_get_work_group <- function(WorkGroup) {
  op <- new_operation(
    name = "GetWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$get_work_group_input(WorkGroup = WorkGroup)
  output <- .athena$get_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$get_work_group <- athena_get_work_group

#' Imports a single ipynb file to a Spark enabled workgroup
#'
#' @description
#' Imports a single `ipynb` file to a Spark enabled workgroup. The maximum file size that can be imported is 10 megabytes. If an `ipynb` file with the same name already exists in the workgroup, throws an error.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_import_notebook/](https://www.paws-r-sdk.com/docs/athena_import_notebook/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The name of the Spark enabled workgroup to import the notebook to.
#' @param Name &#91;required&#93; The name of the notebook to import.
#' @param Payload &#91;required&#93; The notebook content to be imported.
#' @param Type &#91;required&#93; The notebook content type. Currently, the only valid type is `IPYNB`.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to import the
#' notebook is idempotent (executes only once).
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for you. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#'
#' @keywords internal
#'
#' @rdname athena_import_notebook
athena_import_notebook <- function(WorkGroup, Name, Payload, Type, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "ImportNotebook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$import_notebook_input(WorkGroup = WorkGroup, Name = Name, Payload = Payload, Type = Type, ClientRequestToken = ClientRequestToken)
  output <- .athena$import_notebook_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$import_notebook <- athena_import_notebook

#' Returns the supported DPU sizes for the supported application runtimes
#' (for example, Athena notebook version 1)
#'
#' @description
#' Returns the supported DPU sizes for the supported application runtimes (for example, `Athena notebook version 1`).
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_application_dpu_sizes/](https://www.paws-r-sdk.com/docs/athena_list_application_dpu_sizes/) for full documentation.
#'
#' @param MaxResults Specifies the maximum number of results to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated.
#'
#' @keywords internal
#'
#' @rdname athena_list_application_dpu_sizes
athena_list_application_dpu_sizes <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationDPUSizes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_application_dpu_sizes_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .athena$list_application_dpu_sizes_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_application_dpu_sizes <- athena_list_application_dpu_sizes

#' Lists the calculations that have been submitted to a session in
#' descending order
#'
#' @description
#' Lists the calculations that have been submitted to a session in descending order. Newer calculations are listed first; older calculations are listed later.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_calculation_executions/](https://www.paws-r-sdk.com/docs/athena_list_calculation_executions/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#' @param StateFilter A filter for a specific calculation execution state. A description of
#' each state follows.
#' 
#' `CREATING` - The calculation is in the process of being created.
#' 
#' `CREATED` - The calculation has been created and is ready to run.
#' 
#' `QUEUED` - The calculation has been queued for processing.
#' 
#' `RUNNING` - The calculation is running.
#' 
#' `CANCELING` - A request to cancel the calculation has been received and
#' the system is working to stop it.
#' 
#' `CANCELED` - The calculation is no longer running as the result of a
#' cancel request.
#' 
#' `COMPLETED` - The calculation has completed without error.
#' 
#' `FAILED` - The calculation failed and is no longer running.
#' @param MaxResults The maximum number of calculation executions to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#'
#' @keywords internal
#'
#' @rdname athena_list_calculation_executions
athena_list_calculation_executions <- function(SessionId, StateFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCalculationExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_calculation_executions_input(SessionId = SessionId, StateFilter = StateFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .athena$list_calculation_executions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_calculation_executions <- athena_list_calculation_executions

#' Lists the capacity reservations for the current account
#'
#' @description
#' Lists the capacity reservations for the current account.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_capacity_reservations/](https://www.paws-r-sdk.com/docs/athena_list_capacity_reservations/) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_capacity_reservations
athena_list_capacity_reservations <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCapacityReservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_capacity_reservations_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_capacity_reservations_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_capacity_reservations <- athena_list_capacity_reservations

#' Lists the data catalogs in the current Amazon Web Services account
#'
#' @description
#' Lists the data catalogs in the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_data_catalogs/](https://www.paws-r-sdk.com/docs/athena_list_data_catalogs/) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the NextToken from the response object of the previous
#' page call.
#' @param MaxResults Specifies the maximum number of data catalogs to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_data_catalogs
athena_list_data_catalogs <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDataCatalogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_data_catalogs_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_data_catalogs_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_data_catalogs <- athena_list_data_catalogs

#' Lists the databases in the specified data catalog
#'
#' @description
#' Lists the databases in the specified data catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_databases/](https://www.paws-r-sdk.com/docs/athena_list_databases/) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog that contains the databases to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_databases
athena_list_databases <- function(CatalogName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_databases_input(CatalogName = CatalogName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_databases_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_databases <- athena_list_databases

#' Returns a list of engine versions that are available to choose from,
#' including the Auto option
#'
#' @description
#' Returns a list of engine versions that are available to choose from, including the Auto option.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_engine_versions/](https://www.paws-r-sdk.com/docs/athena_list_engine_versions/) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of engine versions to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_list_engine_versions
athena_list_engine_versions <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_engine_versions_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_engine_versions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_engine_versions <- athena_list_engine_versions

#' Lists, in descending order, the executors that joined a session
#'
#' @description
#' Lists, in descending order, the executors that joined a session. Newer executors are listed first; older executors are listed later. The result can be optionally filtered by state.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_executors/](https://www.paws-r-sdk.com/docs/athena_list_executors/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#' @param ExecutorStateFilter A filter for a specific executor state. A description of each state
#' follows.
#' 
#' `CREATING` - The executor is being started, including acquiring
#' resources.
#' 
#' `CREATED` - The executor has been started.
#' 
#' `REGISTERED` - The executor has been registered.
#' 
#' `TERMINATING` - The executor is in the process of shutting down.
#' 
#' `TERMINATED` - The executor is no longer running.
#' 
#' `FAILED` - Due to a failure, the executor is no longer running.
#' @param MaxResults The maximum number of executors to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#'
#' @keywords internal
#'
#' @rdname athena_list_executors
athena_list_executors <- function(SessionId, ExecutorStateFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListExecutors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_executors_input(SessionId = SessionId, ExecutorStateFilter = ExecutorStateFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .athena$list_executors_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_executors <- athena_list_executors

#' Provides a list of available query IDs only for queries saved in the
#' specified workgroup
#'
#' @description
#' Provides a list of available query IDs only for queries saved in the specified workgroup. Requires that you have access to the specified workgroup. If a workgroup is not specified, lists the saved queries for the primary workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_named_queries/](https://www.paws-r-sdk.com/docs/athena_list_named_queries/) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of queries to return in this request.
#' @param WorkGroup The name of the workgroup from which the named queries are being
#' returned. If a workgroup is not specified, the saved queries for the
#' primary workgroup are returned.
#'
#' @keywords internal
#'
#' @rdname athena_list_named_queries
athena_list_named_queries <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListNamedQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_named_queries_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_named_queries_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_named_queries <- athena_list_named_queries

#' Displays the notebook files for the specified workgroup in paginated
#' format
#'
#' @description
#' Displays the notebook files for the specified workgroup in paginated format.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_notebook_metadata/](https://www.paws-r-sdk.com/docs/athena_list_notebook_metadata/) for full documentation.
#'
#' @param Filters Search filter string.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated.
#' @param MaxResults Specifies the maximum number of results to return.
#' @param WorkGroup &#91;required&#93; The name of the Spark enabled workgroup to retrieve notebook metadata
#' for.
#'
#' @keywords internal
#'
#' @rdname athena_list_notebook_metadata
athena_list_notebook_metadata <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL, WorkGroup) {
  op <- new_operation(
    name = "ListNotebookMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_notebook_metadata_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_notebook_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_notebook_metadata <- athena_list_notebook_metadata

#' Lists, in descending order, the sessions that have been created in a
#' notebook that are in an active state like CREATING, CREATED, IDLE or
#' BUSY
#'
#' @description
#' Lists, in descending order, the sessions that have been created in a notebook that are in an active state like `CREATING`, `CREATED`, `IDLE` or `BUSY`. Newer sessions are listed first; older sessions are listed later.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_notebook_sessions/](https://www.paws-r-sdk.com/docs/athena_list_notebook_sessions/) for full documentation.
#'
#' @param NotebookId &#91;required&#93; The ID of the notebook to list sessions for.
#' @param MaxResults The maximum number of notebook sessions to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#'
#' @keywords internal
#'
#' @rdname athena_list_notebook_sessions
athena_list_notebook_sessions <- function(NotebookId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListNotebookSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_notebook_sessions_input(NotebookId = NotebookId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .athena$list_notebook_sessions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_notebook_sessions <- athena_list_notebook_sessions

#' Lists the prepared statements in the specified workgroup
#'
#' @description
#' Lists the prepared statements in the specified workgroup.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_prepared_statements/](https://www.paws-r-sdk.com/docs/athena_list_prepared_statements/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The workgroup to list the prepared statements for.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of results to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_list_prepared_statements
athena_list_prepared_statements <- function(WorkGroup, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPreparedStatements",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_prepared_statements_input(WorkGroup = WorkGroup, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_prepared_statements_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_prepared_statements <- athena_list_prepared_statements

#' Provides a list of available query execution IDs for the queries in the
#' specified workgroup
#'
#' @description
#' Provides a list of available query execution IDs for the queries in the specified workgroup. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_query_executions/](https://www.paws-r-sdk.com/docs/athena_list_query_executions/) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of query executions to return in this request.
#' @param WorkGroup The name of the workgroup from which queries are being returned. If a
#' workgroup is not specified, a list of available query execution IDs for
#' the queries in the primary workgroup is returned.
#'
#' @keywords internal
#'
#' @rdname athena_list_query_executions
athena_list_query_executions <- function(NextToken = NULL, MaxResults = NULL, WorkGroup = NULL) {
  op <- new_operation(
    name = "ListQueryExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_query_executions_input(NextToken = NextToken, MaxResults = MaxResults, WorkGroup = WorkGroup)
  output <- .athena$list_query_executions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_query_executions <- athena_list_query_executions

#' Lists the sessions in a workgroup that are in an active state like
#' CREATING, CREATED, IDLE, or BUSY
#'
#' @description
#' Lists the sessions in a workgroup that are in an active state like `CREATING`, `CREATED`, `IDLE`, or `BUSY`. Newer sessions are listed first; older sessions are listed later.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_sessions/](https://www.paws-r-sdk.com/docs/athena_list_sessions/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The workgroup to which the session belongs.
#' @param StateFilter A filter for a specific session state. A description of each state
#' follows.
#' 
#' `CREATING` - The session is being started, including acquiring
#' resources.
#' 
#' `CREATED` - The session has been started.
#' 
#' `IDLE` - The session is able to accept a calculation.
#' 
#' `BUSY` - The session is processing another task and is unable to accept
#' a calculation.
#' 
#' `TERMINATING` - The session is in the process of shutting down.
#' 
#' `TERMINATED` - The session and its resources are no longer running.
#' 
#' `DEGRADED` - The session has no healthy coordinators.
#' 
#' `FAILED` - Due to a failure, the session and its resources are no longer
#' running.
#' @param MaxResults The maximum number of sessions to return.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#'
#' @keywords internal
#'
#' @rdname athena_list_sessions
athena_list_sessions <- function(WorkGroup, StateFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_sessions_input(WorkGroup = WorkGroup, StateFilter = StateFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .athena$list_sessions_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_sessions <- athena_list_sessions

#' Lists the metadata for the tables in the specified data catalog database
#'
#' @description
#' Lists the metadata for the tables in the specified data catalog database.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_table_metadata/](https://www.paws-r-sdk.com/docs/athena_list_table_metadata/) for full documentation.
#'
#' @param CatalogName &#91;required&#93; The name of the data catalog for which table metadata should be
#' returned.
#' @param DatabaseName &#91;required&#93; The name of the database for which table metadata should be returned.
#' @param Expression A regex filter that pattern-matches table names. If no expression is
#' supplied, metadata for all tables are listed.
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the NextToken from the response object of the previous
#' page call.
#' @param MaxResults Specifies the maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname athena_list_table_metadata
athena_list_table_metadata <- function(CatalogName, DatabaseName, Expression = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTableMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_table_metadata_input(CatalogName = CatalogName, DatabaseName = DatabaseName, Expression = Expression, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_table_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_table_metadata <- athena_list_table_metadata

#' Lists the tags associated with an Athena resource
#'
#' @description
#' Lists the tags associated with an Athena resource.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/athena_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Lists the tags for the resource with the specified ARN.
#' @param NextToken The token for the next set of results, or null if there are no
#' additional results for this request, where the request lists the tags
#' for the resource with the specified ARN.
#' @param MaxResults The maximum number of results to be returned per request that lists the
#' tags for the resource.
#'
#' @keywords internal
#'
#' @rdname athena_list_tags_for_resource
athena_list_tags_for_resource <- function(ResourceARN, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_tags_for_resource_input(ResourceARN = ResourceARN, NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_tags_for_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_tags_for_resource <- athena_list_tags_for_resource

#' Lists available workgroups for the account
#'
#' @description
#' Lists available workgroups for the account.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_list_work_groups/](https://www.paws-r-sdk.com/docs/athena_list_work_groups/) for full documentation.
#'
#' @param NextToken A token generated by the Athena service that specifies where to continue
#' pagination if a previous request was truncated. To obtain the next set
#' of pages, pass in the `NextToken` from the response object of the
#' previous page call.
#' @param MaxResults The maximum number of workgroups to return in this request.
#'
#' @keywords internal
#'
#' @rdname athena_list_work_groups
athena_list_work_groups <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$list_work_groups_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .athena$list_work_groups_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$list_work_groups <- athena_list_work_groups

#' Puts a new capacity assignment configuration for a specified capacity
#' reservation
#'
#' @description
#' Puts a new capacity assignment configuration for a specified capacity reservation. If a capacity assignment configuration already exists for the capacity reservation, replaces the existing capacity assignment configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_put_capacity_assignment_configuration/](https://www.paws-r-sdk.com/docs/athena_put_capacity_assignment_configuration/) for full documentation.
#'
#' @param CapacityReservationName &#91;required&#93; The name of the capacity reservation to put a capacity assignment
#' configuration for.
#' @param CapacityAssignments &#91;required&#93; The list of assignments for the capacity assignment configuration.
#'
#' @keywords internal
#'
#' @rdname athena_put_capacity_assignment_configuration
athena_put_capacity_assignment_configuration <- function(CapacityReservationName, CapacityAssignments) {
  op <- new_operation(
    name = "PutCapacityAssignmentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$put_capacity_assignment_configuration_input(CapacityReservationName = CapacityReservationName, CapacityAssignments = CapacityAssignments)
  output <- .athena$put_capacity_assignment_configuration_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$put_capacity_assignment_configuration <- athena_put_capacity_assignment_configuration

#' Submits calculations for execution within a session
#'
#' @description
#' Submits calculations for execution within a session. You can supply the code to run as an inline code block within the request.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_start_calculation_execution/](https://www.paws-r-sdk.com/docs/athena_start_calculation_execution/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#' @param Description A description of the calculation.
#' @param CalculationConfiguration Contains configuration information for the calculation.
#' @param CodeBlock A string that contains the code of the calculation.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' calculation is idempotent (executes only once). If another
#' `StartCalculationExecutionRequest` is received, the same response is
#' returned and another calculation is not created. If a parameter has
#' changed, an error is returned.
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for users. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#'
#' @keywords internal
#'
#' @rdname athena_start_calculation_execution
athena_start_calculation_execution <- function(SessionId, Description = NULL, CalculationConfiguration = NULL, CodeBlock = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "StartCalculationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$start_calculation_execution_input(SessionId = SessionId, Description = Description, CalculationConfiguration = CalculationConfiguration, CodeBlock = CodeBlock, ClientRequestToken = ClientRequestToken)
  output <- .athena$start_calculation_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$start_calculation_execution <- athena_start_calculation_execution

#' Runs the SQL query statements contained in the Query
#'
#' @description
#' Runs the SQL query statements contained in the `Query`. Requires you to have access to the workgroup in which the query ran. Running queries against an external catalog requires [`get_data_catalog`][athena_get_data_catalog] permission to the catalog. For code samples using the Amazon Web Services SDK for Java, see [Examples and Code Samples](https://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the *Amazon Athena User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_start_query_execution/](https://www.paws-r-sdk.com/docs/athena_start_query_execution/) for full documentation.
#'
#' @param QueryString &#91;required&#93; The SQL query statements to be executed.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' query is idempotent (executes only once). If another
#' [`start_query_execution`][athena_start_query_execution] request is
#' received, the same response is returned and another query is not
#' created. If a parameter has changed, for example, the `QueryString`, an
#' error is returned.
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for users. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#' @param QueryExecutionContext The database within which the query executes.
#' @param ResultConfiguration Specifies information about where and how to save the results of the
#' query execution. If the query runs in a workgroup, then workgroup's
#' settings may override query settings. This affects the query results
#' location. The workgroup settings override is specified in
#' EnforceWorkGroupConfiguration (true/false) in the
#' WorkGroupConfiguration. See
#' WorkGroupConfiguration$EnforceWorkGroupConfiguration.
#' @param WorkGroup The name of the workgroup in which the query is being started.
#' @param ExecutionParameters A list of values for the parameters in a query. The values are applied
#' sequentially to the parameters in the query in the order in which the
#' parameters occur.
#' @param ResultReuseConfiguration Specifies the query result reuse behavior for the query.
#'
#' @keywords internal
#'
#' @rdname athena_start_query_execution
athena_start_query_execution <- function(QueryString, ClientRequestToken = NULL, QueryExecutionContext = NULL, ResultConfiguration = NULL, WorkGroup = NULL, ExecutionParameters = NULL, ResultReuseConfiguration = NULL) {
  op <- new_operation(
    name = "StartQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$start_query_execution_input(QueryString = QueryString, ClientRequestToken = ClientRequestToken, QueryExecutionContext = QueryExecutionContext, ResultConfiguration = ResultConfiguration, WorkGroup = WorkGroup, ExecutionParameters = ExecutionParameters, ResultReuseConfiguration = ResultReuseConfiguration)
  output <- .athena$start_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$start_query_execution <- athena_start_query_execution

#' Creates a session for running calculations within a workgroup
#'
#' @description
#' Creates a session for running calculations within a workgroup. The session is ready when it reaches an `IDLE` state.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_start_session/](https://www.paws-r-sdk.com/docs/athena_start_session/) for full documentation.
#'
#' @param Description The session description.
#' @param WorkGroup &#91;required&#93; The workgroup to which the session belongs.
#' @param EngineConfiguration &#91;required&#93; Contains engine data processing unit (DPU) configuration settings and
#' parameter mappings.
#' @param NotebookVersion The notebook version. This value is supplied automatically for notebook
#' sessions in the Athena console and is not required for programmatic
#' session access. The only valid notebook version is
#' `Athena notebook version 1`. If you specify a value for
#' `NotebookVersion`, you must also specify a value for `NotebookId`. See
#' EngineConfiguration$AdditionalConfigs.
#' @param SessionIdleTimeoutInMinutes The idle timeout in minutes for the session.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' session is idempotent (executes only once). If another
#' `StartSessionRequest` is received, the same response is returned and
#' another session is not created. If a parameter has changed, an error is
#' returned.
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for users. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#'
#' @keywords internal
#'
#' @rdname athena_start_session
athena_start_session <- function(Description = NULL, WorkGroup, EngineConfiguration, NotebookVersion = NULL, SessionIdleTimeoutInMinutes = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "StartSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$start_session_input(Description = Description, WorkGroup = WorkGroup, EngineConfiguration = EngineConfiguration, NotebookVersion = NotebookVersion, SessionIdleTimeoutInMinutes = SessionIdleTimeoutInMinutes, ClientRequestToken = ClientRequestToken)
  output <- .athena$start_session_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$start_session <- athena_start_session

#' Requests the cancellation of a calculation
#'
#' @description
#' Requests the cancellation of a calculation. A [`stop_calculation_execution`][athena_stop_calculation_execution] call on a calculation that is already in a terminal state (for example, `STOPPED`, `FAILED`, or `COMPLETED`) succeeds but has no effect.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_stop_calculation_execution/](https://www.paws-r-sdk.com/docs/athena_stop_calculation_execution/) for full documentation.
#'
#' @param CalculationExecutionId &#91;required&#93; The calculation execution UUID.
#'
#' @keywords internal
#'
#' @rdname athena_stop_calculation_execution
athena_stop_calculation_execution <- function(CalculationExecutionId) {
  op <- new_operation(
    name = "StopCalculationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$stop_calculation_execution_input(CalculationExecutionId = CalculationExecutionId)
  output <- .athena$stop_calculation_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$stop_calculation_execution <- athena_stop_calculation_execution

#' Stops a query execution
#'
#' @description
#' Stops a query execution. Requires you to have access to the workgroup in which the query ran.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_stop_query_execution/](https://www.paws-r-sdk.com/docs/athena_stop_query_execution/) for full documentation.
#'
#' @param QueryExecutionId &#91;required&#93; The unique ID of the query execution to stop.
#'
#' @keywords internal
#'
#' @rdname athena_stop_query_execution
athena_stop_query_execution <- function(QueryExecutionId) {
  op <- new_operation(
    name = "StopQueryExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$stop_query_execution_input(QueryExecutionId = QueryExecutionId)
  output <- .athena$stop_query_execution_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$stop_query_execution <- athena_stop_query_execution

#' Adds one or more tags to an Athena resource
#'
#' @description
#' Adds one or more tags to an Athena resource. A tag is a label that you assign to a resource. Each tag consists of a key and an optional value, both of which you define. For example, you can use tags to categorize Athena workgroups, data catalogs, or capacity reservations by purpose, owner, or environment. Use a consistent set of tag keys to make it easier to search and filter the resources in your account. For best practices, see [Tagging Best Practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html). Tag keys can be from 1 to 128 UTF-8 Unicode characters, and tag values can be from 0 to 256 UTF-8 Unicode characters. Tags can use letters and numbers representable in UTF-8, and the following characters: + - = . _ : / @@. Tag keys and values are case-sensitive. Tag keys must be unique per resource. If you specify more than one tag, separate them by commas.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_tag_resource/](https://www.paws-r-sdk.com/docs/athena_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Specifies the ARN of the Athena resource to which tags are to be added.
#' @param Tags &#91;required&#93; A collection of one or more tags, separated by commas, to be added to an
#' Athena resource.
#'
#' @keywords internal
#'
#' @rdname athena_tag_resource
athena_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .athena$tag_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$tag_resource <- athena_tag_resource

#' Terminates an active session
#'
#' @description
#' Terminates an active session. A [`terminate_session`][athena_terminate_session] call on a session that is already inactive (for example, in a `FAILED`, `TERMINATED` or `TERMINATING` state) succeeds but has no effect. Calculations running in the session when [`terminate_session`][athena_terminate_session] is called are forcefully stopped, but may display as `FAILED` instead of `STOPPED`.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_terminate_session/](https://www.paws-r-sdk.com/docs/athena_terminate_session/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The session ID.
#'
#' @keywords internal
#'
#' @rdname athena_terminate_session
athena_terminate_session <- function(SessionId) {
  op <- new_operation(
    name = "TerminateSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$terminate_session_input(SessionId = SessionId)
  output <- .athena$terminate_session_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$terminate_session <- athena_terminate_session

#' Removes one or more tags from an Athena resource
#'
#' @description
#' Removes one or more tags from an Athena resource.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_untag_resource/](https://www.paws-r-sdk.com/docs/athena_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; Specifies the ARN of the resource from which tags are to be removed.
#' @param TagKeys &#91;required&#93; A comma-separated list of one or more tag keys whose tags are to be
#' removed from the specified resource.
#'
#' @keywords internal
#'
#' @rdname athena_untag_resource
athena_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .athena$untag_resource_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$untag_resource <- athena_untag_resource

#' Updates the number of requested data processing units for the capacity
#' reservation with the specified name
#'
#' @description
#' Updates the number of requested data processing units for the capacity reservation with the specified name.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_capacity_reservation/](https://www.paws-r-sdk.com/docs/athena_update_capacity_reservation/) for full documentation.
#'
#' @param TargetDpus &#91;required&#93; The new number of requested data processing units.
#' @param Name &#91;required&#93; The name of the capacity reservation.
#'
#' @keywords internal
#'
#' @rdname athena_update_capacity_reservation
athena_update_capacity_reservation <- function(TargetDpus, Name) {
  op <- new_operation(
    name = "UpdateCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_capacity_reservation_input(TargetDpus = TargetDpus, Name = Name)
  output <- .athena$update_capacity_reservation_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_capacity_reservation <- athena_update_capacity_reservation

#' Updates the data catalog that has the specified name
#'
#' @description
#' Updates the data catalog that has the specified name.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_data_catalog/](https://www.paws-r-sdk.com/docs/athena_update_data_catalog/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the data catalog to update. The catalog name must be unique
#' for the Amazon Web Services account and can use a maximum of 127
#' alphanumeric, underscore, at sign, or hyphen characters. The remainder
#' of the length constraint of 256 is reserved for use by Athena.
#' @param Type &#91;required&#93; Specifies the type of data catalog to update. Specify `LAMBDA` for a
#' federated catalog, `HIVE` for an external hive metastore, or `GLUE` for
#' an Glue Data Catalog.
#' @param Description New or modified text that describes the data catalog.
#' @param Parameters Specifies the Lambda function or functions to use for updating the data
#' catalog. This is a mapping whose values depend on the catalog type.
#' 
#' -   For the `HIVE` data catalog type, use the following syntax. The
#'     `metadata-function` parameter is required. `The sdk-version`
#'     parameter is optional and defaults to the currently supported
#'     version.
#' 
#'     `metadata-function=lambda_arn, sdk-version=version_number `
#' 
#' -   For the `LAMBDA` data catalog type, use one of the following sets of
#'     required parameters, but not both.
#' 
#'     -   If you have one Lambda function that processes metadata and
#'         another for reading the actual data, use the following syntax.
#'         Both parameters are required.
#' 
#'         `metadata-function=lambda_arn, record-function=lambda_arn `
#' 
#'     -   If you have a composite Lambda function that processes both
#'         metadata and data, use the following syntax to specify your
#'         Lambda function.
#' 
#'         `function=lambda_arn `
#'
#' @keywords internal
#'
#' @rdname athena_update_data_catalog
athena_update_data_catalog <- function(Name, Type, Description = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "UpdateDataCatalog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_data_catalog_input(Name = Name, Type = Type, Description = Description, Parameters = Parameters)
  output <- .athena$update_data_catalog_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_data_catalog <- athena_update_data_catalog

#' Updates a NamedQuery object
#'
#' @description
#' Updates a NamedQuery object. The database or workgroup cannot be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_named_query/](https://www.paws-r-sdk.com/docs/athena_update_named_query/) for full documentation.
#'
#' @param NamedQueryId &#91;required&#93; The unique identifier (UUID) of the query.
#' @param Name &#91;required&#93; The name of the query.
#' @param Description The query description.
#' @param QueryString &#91;required&#93; The contents of the query with all query statements.
#'
#' @keywords internal
#'
#' @rdname athena_update_named_query
athena_update_named_query <- function(NamedQueryId, Name, Description = NULL, QueryString) {
  op <- new_operation(
    name = "UpdateNamedQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_named_query_input(NamedQueryId = NamedQueryId, Name = Name, Description = Description, QueryString = QueryString)
  output <- .athena$update_named_query_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_named_query <- athena_update_named_query

#' Updates the contents of a Spark notebook
#'
#' @description
#' Updates the contents of a Spark notebook.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_notebook/](https://www.paws-r-sdk.com/docs/athena_update_notebook/) for full documentation.
#'
#' @param NotebookId &#91;required&#93; The ID of the notebook to update.
#' @param Payload &#91;required&#93; The updated content for the notebook.
#' @param Type &#91;required&#93; The notebook content type. Currently, the only valid type is `IPYNB`.
#' @param SessionId The active notebook session ID. Required if the notebook has an active
#' session.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' notebook is idempotent (executes only once).
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for you. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#'
#' @keywords internal
#'
#' @rdname athena_update_notebook
athena_update_notebook <- function(NotebookId, Payload, Type, SessionId = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNotebook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_notebook_input(NotebookId = NotebookId, Payload = Payload, Type = Type, SessionId = SessionId, ClientRequestToken = ClientRequestToken)
  output <- .athena$update_notebook_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_notebook <- athena_update_notebook

#' Updates the metadata for a notebook
#'
#' @description
#' Updates the metadata for a notebook.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_notebook_metadata/](https://www.paws-r-sdk.com/docs/athena_update_notebook_metadata/) for full documentation.
#'
#' @param NotebookId &#91;required&#93; The ID of the notebook to update the metadata for.
#' @param ClientRequestToken A unique case-sensitive string used to ensure the request to create the
#' notebook is idempotent (executes only once).
#' 
#' This token is listed as not required because Amazon Web Services SDKs
#' (for example the Amazon Web Services SDK for Java) auto-generate the
#' token for you. If you are not using the Amazon Web Services SDK or the
#' Amazon Web Services CLI, you must provide this token or the action will
#' fail.
#' @param Name &#91;required&#93; The name to update the notebook to.
#'
#' @keywords internal
#'
#' @rdname athena_update_notebook_metadata
athena_update_notebook_metadata <- function(NotebookId, ClientRequestToken = NULL, Name) {
  op <- new_operation(
    name = "UpdateNotebookMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_notebook_metadata_input(NotebookId = NotebookId, ClientRequestToken = ClientRequestToken, Name = Name)
  output <- .athena$update_notebook_metadata_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_notebook_metadata <- athena_update_notebook_metadata

#' Updates a prepared statement
#'
#' @description
#' Updates a prepared statement.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_prepared_statement/](https://www.paws-r-sdk.com/docs/athena_update_prepared_statement/) for full documentation.
#'
#' @param StatementName &#91;required&#93; The name of the prepared statement.
#' @param WorkGroup &#91;required&#93; The workgroup for the prepared statement.
#' @param QueryStatement &#91;required&#93; The query string for the prepared statement.
#' @param Description The description of the prepared statement.
#'
#' @keywords internal
#'
#' @rdname athena_update_prepared_statement
athena_update_prepared_statement <- function(StatementName, WorkGroup, QueryStatement, Description = NULL) {
  op <- new_operation(
    name = "UpdatePreparedStatement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_prepared_statement_input(StatementName = StatementName, WorkGroup = WorkGroup, QueryStatement = QueryStatement, Description = Description)
  output <- .athena$update_prepared_statement_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_prepared_statement <- athena_update_prepared_statement

#' Updates the workgroup with the specified name
#'
#' @description
#' Updates the workgroup with the specified name. The workgroup's name cannot be changed. Only `ConfigurationUpdates` can be specified.
#'
#' See [https://www.paws-r-sdk.com/docs/athena_update_work_group/](https://www.paws-r-sdk.com/docs/athena_update_work_group/) for full documentation.
#'
#' @param WorkGroup &#91;required&#93; The specified workgroup that will be updated.
#' @param Description The workgroup description.
#' @param ConfigurationUpdates Contains configuration updates for an Athena SQL workgroup.
#' @param State The workgroup state that will be updated for the given workgroup.
#'
#' @keywords internal
#'
#' @rdname athena_update_work_group
athena_update_work_group <- function(WorkGroup, Description = NULL, ConfigurationUpdates = NULL, State = NULL) {
  op <- new_operation(
    name = "UpdateWorkGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .athena$update_work_group_input(WorkGroup = WorkGroup, Description = Description, ConfigurationUpdates = ConfigurationUpdates, State = State)
  output <- .athena$update_work_group_output()
  config <- get_config()
  svc <- .athena$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.athena$operations$update_work_group <- athena_update_work_group
