% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_theme}
\alias{quicksight_create_theme}
\title{Creates a theme}
\usage{
quicksight_create_theme(
  AwsAccountId,
  ThemeId,
  Name,
  BaseThemeId,
  VersionDescription = NULL,
  Configuration,
  Permissions = NULL,
  Tags = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services account where you want to store the
new theme.}

\item{ThemeId}{[required] An ID for the theme that you want to create. The theme ID is unique per
Amazon Web Services Region in each Amazon Web Services account.}

\item{Name}{[required] A display name for the theme.}

\item{BaseThemeId}{[required] The ID of the theme that a custom theme will inherit from. All themes
inherit from one of the starting themes defined by Amazon QuickSight.
For a list of the starting themes, use
\code{\link[=quicksight_list_themes]{list_themes}} or choose \strong{Themes} from within
an analysis.}

\item{VersionDescription}{A description of the first version of the theme that you're creating.
Every time \code{\link[=quicksight_update_theme]{update_theme}} is called, a new
version is created. Each version of the theme has a description of the
version in the \code{VersionDescription} field.}

\item{Configuration}{[required] The theme configuration, which contains the theme display properties.}

\item{Permissions}{A valid grouping of resource permissions to apply to the new theme.}

\item{Tags}{A map of the key-value pairs for the resource tag or tags that you want
to add to the resource.}
}
\description{
Creates a theme.

See \url{https://paws-r.github.io/docs/quicksight/create_theme.html} for full documentation.
}
\keyword{internal}
