% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_get_shard_iterator}
\alias{kinesis_get_shard_iterator}
\title{Gets an Amazon Kinesis shard iterator}
\usage{
kinesis_get_shard_iterator(
  StreamName,
  ShardId,
  ShardIteratorType,
  StartingSequenceNumber = NULL,
  Timestamp = NULL
)
}
\arguments{
\item{StreamName}{[required] The name of the Amazon Kinesis data stream.}

\item{ShardId}{[required] The shard ID of the Kinesis Data Streams shard to get the iterator for.}

\item{ShardIteratorType}{[required] Determines how the shard iterator is used to start reading data records
from the shard.

The following are the valid Amazon Kinesis shard iterator types:
\itemize{
\item AT_SEQUENCE_NUMBER - Start reading from the position denoted by a
specific sequence number, provided in the value
\code{StartingSequenceNumber}.
\item AFTER_SEQUENCE_NUMBER - Start reading right after the position
denoted by a specific sequence number, provided in the value
\code{StartingSequenceNumber}.
\item AT_TIMESTAMP - Start reading from the position denoted by a specific
time stamp, provided in the value \code{Timestamp}.
\item TRIM_HORIZON - Start reading at the last untrimmed record in the
shard in the system, which is the oldest data record in the shard.
\item LATEST - Start reading just after the most recent record in the
shard, so that you always read the most recent data in the shard.
}}

\item{StartingSequenceNumber}{The sequence number of the data record in the shard from which to start
reading. Used with shard iterator type AT_SEQUENCE_NUMBER and
AFTER_SEQUENCE_NUMBER.}

\item{Timestamp}{The time stamp of the data record from which to start reading. Used with
shard iterator type AT_TIMESTAMP. A time stamp is the Unix epoch date
with precision in milliseconds. For example,
\verb{2016-04-04T19:58:46.480-00:00} or \code{1459799926.480}. If a record with
this exact time stamp does not exist, the iterator returned is for the
next (later) record. If the time stamp is older than the current trim
horizon, the iterator returned is for the oldest untrimmed data record
(TRIM_HORIZON).}
}
\description{
Gets an Amazon Kinesis shard iterator. A shard iterator expires 5 minutes after it is returned to the requester.

See \url{https://paws-r.github.io/docs/kinesis/get_shard_iterator.html} for full documentation.
}
\keyword{internal}
