% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_table}
\alias{glue_get_table}
\title{Retrieves the Table definition in a Data Catalog for a specified table}
\usage{
glue_get_table(
  CatalogId = NULL,
  DatabaseName,
  Name,
  TransactionId = NULL,
  QueryAsOfTime = NULL
)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the table resides. If none is provided,
the Amazon Web Services account ID is used by default.}

\item{DatabaseName}{[required] The name of the database in the catalog in which the table resides. For
Hive compatibility, this name is entirely lowercase.}

\item{Name}{[required] The name of the table for which to retrieve the definition. For Hive
compatibility, this name is entirely lowercase.}

\item{TransactionId}{The transaction ID at which to read the table contents.}

\item{QueryAsOfTime}{The time as of when to read the table contents. If not set, the most
recent transaction commit time will be used. Cannot be specified along
with \code{TransactionId}.}
}
\description{
Retrieves the \code{Table} definition in a Data Catalog for a specified table.

See \url{https://paws-r.github.io/docs/glue/get_table.html} for full documentation.
}
\keyword{internal}
