% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_define_index_field}
\alias{cloudsearch_define_index_field}
\title{Configures an IndexField for the search domain}
\usage{
cloudsearch_define_index_field(DomainName, IndexField)
}
\arguments{
\item{DomainName}{[required]}

\item{IndexField}{[required] The index field and field options you want to configure.}
}
\description{
Configures an \verb{<a>IndexField</a>} for the search domain. Used to create
new fields and modify existing ones. You must specify the name of the
domain you are configuring and an index field configuration. The index
field configuration specifies a unique name, the index field type, and
the options you want to configure for the field. The options you can
specify depend on the \verb{<a>IndexFieldType</a>}. If the field exists, the
new configuration replaces the old one. For more information, see
\href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html}{Configuring Index Fields}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$define_index_field(
  DomainName = "string",
  IndexField = list(
    IndexFieldName = "string",
    IndexFieldType = "int"|"double"|"literal"|"text"|"date"|"latlon"|"int-array"|"double-array"|"literal-array"|"text-array"|"date-array",
    IntOptions = list(
      DefaultValue = 123,
      SourceField = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE,
      SortEnabled = TRUE|FALSE
    ),
    DoubleOptions = list(
      DefaultValue = 123.0,
      SourceField = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE,
      SortEnabled = TRUE|FALSE
    ),
    LiteralOptions = list(
      DefaultValue = "string",
      SourceField = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE,
      SortEnabled = TRUE|FALSE
    ),
    TextOptions = list(
      DefaultValue = "string",
      SourceField = "string",
      ReturnEnabled = TRUE|FALSE,
      SortEnabled = TRUE|FALSE,
      HighlightEnabled = TRUE|FALSE,
      AnalysisScheme = "string"
    ),
    DateOptions = list(
      DefaultValue = "string",
      SourceField = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE,
      SortEnabled = TRUE|FALSE
    ),
    LatLonOptions = list(
      DefaultValue = "string",
      SourceField = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE,
      SortEnabled = TRUE|FALSE
    ),
    IntArrayOptions = list(
      DefaultValue = 123,
      SourceFields = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE
    ),
    DoubleArrayOptions = list(
      DefaultValue = 123.0,
      SourceFields = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE
    ),
    LiteralArrayOptions = list(
      DefaultValue = "string",
      SourceFields = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE
    ),
    TextArrayOptions = list(
      DefaultValue = "string",
      SourceFields = "string",
      ReturnEnabled = TRUE|FALSE,
      HighlightEnabled = TRUE|FALSE,
      AnalysisScheme = "string"
    ),
    DateArrayOptions = list(
      DefaultValue = "string",
      SourceFields = "string",
      FacetEnabled = TRUE|FALSE,
      SearchEnabled = TRUE|FALSE,
      ReturnEnabled = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
