% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_add_instance_groups}
\alias{emr_add_instance_groups}
\title{Adds one or more instance groups to a running cluster}
\usage{
emr_add_instance_groups(InstanceGroups, JobFlowId)
}
\arguments{
\item{InstanceGroups}{[required] Instance groups to add.}

\item{JobFlowId}{[required] Job flow in which to add the instance groups.}
}
\description{
Adds one or more instance groups to a running cluster.
}
\section{Request syntax}{
\preformatted{svc$add_instance_groups(
  InstanceGroups = list(
    list(
      Name = "string",
      Market = "ON_DEMAND"|"SPOT",
      InstanceRole = "MASTER"|"CORE"|"TASK",
      BidPrice = "string",
      InstanceType = "string",
      InstanceCount = 123,
      Configurations = list(
        list(
          Classification = "string",
          Configurations = list(),
          Properties = list(
            "string"
          )
        )
      ),
      EbsConfiguration = list(
        EbsBlockDeviceConfigs = list(
          list(
            VolumeSpecification = list(
              VolumeType = "string",
              Iops = 123,
              SizeInGB = 123
            ),
            VolumesPerInstance = 123
          )
        ),
        EbsOptimized = TRUE|FALSE
      ),
      AutoScalingPolicy = list(
        Constraints = list(
          MinCapacity = 123,
          MaxCapacity = 123
        ),
        Rules = list(
          list(
            Name = "string",
            Description = "string",
            Action = list(
              Market = "ON_DEMAND"|"SPOT",
              SimpleScalingPolicyConfiguration = list(
                AdjustmentType = "CHANGE_IN_CAPACITY"|"PERCENT_CHANGE_IN_CAPACITY"|"EXACT_CAPACITY",
                ScalingAdjustment = 123,
                CoolDown = 123
              )
            ),
            Trigger = list(
              CloudWatchAlarmDefinition = list(
                ComparisonOperator = "GREATER_THAN_OR_EQUAL"|"GREATER_THAN"|"LESS_THAN"|"LESS_THAN_OR_EQUAL",
                EvaluationPeriods = 123,
                MetricName = "string",
                Namespace = "string",
                Period = 123,
                Statistic = "SAMPLE_COUNT"|"AVERAGE"|"SUM"|"MINIMUM"|"MAXIMUM",
                Threshold = 123.0,
                Unit = "NONE"|"SECONDS"|"MICRO_SECONDS"|"MILLI_SECONDS"|"BYTES"|"KILO_BYTES"|"MEGA_BYTES"|"GIGA_BYTES"|"TERA_BYTES"|"BITS"|"KILO_BITS"|"MEGA_BITS"|"GIGA_BITS"|"TERA_BITS"|"PERCENT"|"COUNT"|"BYTES_PER_SECOND"|"KILO_BYTES_PER_SECOND"|"MEGA_BYTES_PER_SECOND"|"GIGA_BYTES_PER_SECOND"|"TERA_BYTES_PER_SECOND"|"BITS_PER_SECOND"|"KILO_BITS_PER_SECOND"|"MEGA_BITS_PER_SECOND"|"GIGA_BITS_PER_SECOND"|"TERA_BITS_PER_SECOND"|"COUNT_PER_SECOND",
                Dimensions = list(
                  list(
                    Key = "string",
                    Value = "string"
                  )
                )
              )
            )
          )
        )
      )
    )
  ),
  JobFlowId = "string"
)
}
}

\keyword{internal}
